/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.LabelCounters;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobInputConfig;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobOutput;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobSummary> {
    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelingJobName").getter(LabelingJobSummary.getter(LabelingJobSummary::labelingJobName)).setter(LabelingJobSummary.setter(Builder::labelingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()}).build();
    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelingJobArn").getter(LabelingJobSummary.getter(LabelingJobSummary::labelingJobArn)).setter(LabelingJobSummary.setter(Builder::labelingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(LabelingJobSummary.getter(LabelingJobSummary::creationTime)).setter(LabelingJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(LabelingJobSummary.getter(LabelingJobSummary::lastModifiedTime)).setter(LabelingJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LABELING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelingJobStatus").getter(LabelingJobSummary.getter(LabelingJobSummary::labelingJobStatusAsString)).setter(LabelingJobSummary.setter(Builder::labelingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobStatus").build()}).build();
    private static final SdkField<LabelCounters> LABEL_COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelCounters").getter(LabelingJobSummary.getter(LabelingJobSummary::labelCounters)).setter(LabelingJobSummary.setter(Builder::labelCounters)).constructor(LabelCounters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCounters").build()}).build();
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkteamArn").getter(LabelingJobSummary.getter(LabelingJobSummary::workteamArn)).setter(LabelingJobSummary.setter(Builder::workteamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()}).build();
    private static final SdkField<String> PRE_HUMAN_TASK_LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreHumanTaskLambdaArn").getter(LabelingJobSummary.getter(LabelingJobSummary::preHumanTaskLambdaArn)).setter(LabelingJobSummary.setter(Builder::preHumanTaskLambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreHumanTaskLambdaArn").build()}).build();
    private static final SdkField<String> ANNOTATION_CONSOLIDATION_LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnnotationConsolidationLambdaArn").getter(LabelingJobSummary.getter(LabelingJobSummary::annotationConsolidationLambdaArn)).setter(LabelingJobSummary.setter(Builder::annotationConsolidationLambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationConsolidationLambdaArn").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(LabelingJobSummary.getter(LabelingJobSummary::failureReason)).setter(LabelingJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<LabelingJobOutput> LABELING_JOB_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelingJobOutput").getter(LabelingJobSummary.getter(LabelingJobSummary::labelingJobOutput)).setter(LabelingJobSummary.setter(Builder::labelingJobOutput)).constructor(LabelingJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobOutput").build()}).build();
    private static final SdkField<LabelingJobInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(LabelingJobSummary.getter(LabelingJobSummary::inputConfig)).setter(LabelingJobSummary.setter(Builder::inputConfig)).constructor(LabelingJobInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_NAME_FIELD, LABELING_JOB_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LABELING_JOB_STATUS_FIELD, LABEL_COUNTERS_FIELD, WORKTEAM_ARN_FIELD, PRE_HUMAN_TASK_LAMBDA_ARN_FIELD, ANNOTATION_CONSOLIDATION_LAMBDA_ARN_FIELD, FAILURE_REASON_FIELD, LABELING_JOB_OUTPUT_FIELD, INPUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LabelingJobName", LABELING_JOB_NAME_FIELD);
            this.put("LabelingJobArn", LABELING_JOB_ARN_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("LabelingJobStatus", LABELING_JOB_STATUS_FIELD);
            this.put("LabelCounters", LABEL_COUNTERS_FIELD);
            this.put("WorkteamArn", WORKTEAM_ARN_FIELD);
            this.put("PreHumanTaskLambdaArn", PRE_HUMAN_TASK_LAMBDA_ARN_FIELD);
            this.put("AnnotationConsolidationLambdaArn", ANNOTATION_CONSOLIDATION_LAMBDA_ARN_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
            this.put("LabelingJobOutput", LABELING_JOB_OUTPUT_FIELD);
            this.put("InputConfig", INPUT_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String labelingJobName;
    private final String labelingJobArn;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String labelingJobStatus;
    private final LabelCounters labelCounters;
    private final String workteamArn;
    private final String preHumanTaskLambdaArn;
    private final String annotationConsolidationLambdaArn;
    private final String failureReason;
    private final LabelingJobOutput labelingJobOutput;
    private final LabelingJobInputConfig inputConfig;

    private LabelingJobSummary(BuilderImpl builder) {
        this.labelingJobName = builder.labelingJobName;
        this.labelingJobArn = builder.labelingJobArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.labelingJobStatus = builder.labelingJobStatus;
        this.labelCounters = builder.labelCounters;
        this.workteamArn = builder.workteamArn;
        this.preHumanTaskLambdaArn = builder.preHumanTaskLambdaArn;
        this.annotationConsolidationLambdaArn = builder.annotationConsolidationLambdaArn;
        this.failureReason = builder.failureReason;
        this.labelingJobOutput = builder.labelingJobOutput;
        this.inputConfig = builder.inputConfig;
    }

    public final String labelingJobName() {
        return this.labelingJobName;
    }

    public final String labelingJobArn() {
        return this.labelingJobArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final LabelingJobStatus labelingJobStatus() {
        return LabelingJobStatus.fromValue(this.labelingJobStatus);
    }

    public final String labelingJobStatusAsString() {
        return this.labelingJobStatus;
    }

    public final LabelCounters labelCounters() {
        return this.labelCounters;
    }

    public final String workteamArn() {
        return this.workteamArn;
    }

    public final String preHumanTaskLambdaArn() {
        return this.preHumanTaskLambdaArn;
    }

    public final String annotationConsolidationLambdaArn() {
        return this.annotationConsolidationLambdaArn;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final LabelingJobOutput labelingJobOutput() {
        return this.labelingJobOutput;
    }

    public final LabelingJobInputConfig inputConfig() {
        return this.inputConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.preHumanTaskLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotationConsolidationLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobSummary)) {
            return false;
        }
        LabelingJobSummary other = (LabelingJobSummary)obj;
        return Objects.equals(this.labelingJobName(), other.labelingJobName()) && Objects.equals(this.labelingJobArn(), other.labelingJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.labelingJobStatusAsString(), other.labelingJobStatusAsString()) && Objects.equals(this.labelCounters(), other.labelCounters()) && Objects.equals(this.workteamArn(), other.workteamArn()) && Objects.equals(this.preHumanTaskLambdaArn(), other.preHumanTaskLambdaArn()) && Objects.equals(this.annotationConsolidationLambdaArn(), other.annotationConsolidationLambdaArn()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.labelingJobOutput(), other.labelingJobOutput()) && Objects.equals(this.inputConfig(), other.inputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"LabelingJobSummary").add("LabelingJobName", (Object)this.labelingJobName()).add("LabelingJobArn", (Object)this.labelingJobArn()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LabelingJobStatus", (Object)this.labelingJobStatusAsString()).add("LabelCounters", (Object)this.labelCounters()).add("WorkteamArn", (Object)this.workteamArn()).add("PreHumanTaskLambdaArn", (Object)this.preHumanTaskLambdaArn()).add("AnnotationConsolidationLambdaArn", (Object)this.annotationConsolidationLambdaArn()).add("FailureReason", (Object)this.failureReason()).add("LabelingJobOutput", (Object)this.labelingJobOutput()).add("InputConfig", (Object)this.inputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelingJobName": {
                return Optional.ofNullable(clazz.cast(this.labelingJobName()));
            }
            case "LabelingJobArn": {
                return Optional.ofNullable(clazz.cast(this.labelingJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LabelingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.labelingJobStatusAsString()));
            }
            case "LabelCounters": {
                return Optional.ofNullable(clazz.cast(this.labelCounters()));
            }
            case "WorkteamArn": {
                return Optional.ofNullable(clazz.cast(this.workteamArn()));
            }
            case "PreHumanTaskLambdaArn": {
                return Optional.ofNullable(clazz.cast(this.preHumanTaskLambdaArn()));
            }
            case "AnnotationConsolidationLambdaArn": {
                return Optional.ofNullable(clazz.cast(this.annotationConsolidationLambdaArn()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "LabelingJobOutput": {
                return Optional.ofNullable(clazz.cast(this.labelingJobOutput()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobSummary, T> g) {
        return obj -> g.apply((LabelingJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String labelingJobName;
        private String labelingJobArn;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String labelingJobStatus;
        private LabelCounters labelCounters;
        private String workteamArn;
        private String preHumanTaskLambdaArn;
        private String annotationConsolidationLambdaArn;
        private String failureReason;
        private LabelingJobOutput labelingJobOutput;
        private LabelingJobInputConfig inputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobSummary model) {
            this.labelingJobName(model.labelingJobName);
            this.labelingJobArn(model.labelingJobArn);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.labelingJobStatus(model.labelingJobStatus);
            this.labelCounters(model.labelCounters);
            this.workteamArn(model.workteamArn);
            this.preHumanTaskLambdaArn(model.preHumanTaskLambdaArn);
            this.annotationConsolidationLambdaArn(model.annotationConsolidationLambdaArn);
            this.failureReason(model.failureReason);
            this.labelingJobOutput(model.labelingJobOutput);
            this.inputConfig(model.inputConfig);
        }

        public final String getLabelingJobName() {
            return this.labelingJobName;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final String getLabelingJobArn() {
            return this.labelingJobArn;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLabelingJobStatus() {
            return this.labelingJobStatus;
        }

        public final void setLabelingJobStatus(String labelingJobStatus) {
            this.labelingJobStatus = labelingJobStatus;
        }

        @Override
        public final Builder labelingJobStatus(String labelingJobStatus) {
            this.labelingJobStatus = labelingJobStatus;
            return this;
        }

        @Override
        public final Builder labelingJobStatus(LabelingJobStatus labelingJobStatus) {
            this.labelingJobStatus(labelingJobStatus == null ? null : labelingJobStatus.toString());
            return this;
        }

        public final LabelCounters.Builder getLabelCounters() {
            return this.labelCounters != null ? this.labelCounters.toBuilder() : null;
        }

        public final void setLabelCounters(LabelCounters.BuilderImpl labelCounters) {
            this.labelCounters = labelCounters != null ? labelCounters.build() : null;
        }

        @Override
        public final Builder labelCounters(LabelCounters labelCounters) {
            this.labelCounters = labelCounters;
            return this;
        }

        public final String getWorkteamArn() {
            return this.workteamArn;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final String getPreHumanTaskLambdaArn() {
            return this.preHumanTaskLambdaArn;
        }

        public final void setPreHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
        }

        @Override
        public final Builder preHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
            return this;
        }

        public final String getAnnotationConsolidationLambdaArn() {
            return this.annotationConsolidationLambdaArn;
        }

        public final void setAnnotationConsolidationLambdaArn(String annotationConsolidationLambdaArn) {
            this.annotationConsolidationLambdaArn = annotationConsolidationLambdaArn;
        }

        @Override
        public final Builder annotationConsolidationLambdaArn(String annotationConsolidationLambdaArn) {
            this.annotationConsolidationLambdaArn = annotationConsolidationLambdaArn;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final LabelingJobOutput.Builder getLabelingJobOutput() {
            return this.labelingJobOutput != null ? this.labelingJobOutput.toBuilder() : null;
        }

        public final void setLabelingJobOutput(LabelingJobOutput.BuilderImpl labelingJobOutput) {
            this.labelingJobOutput = labelingJobOutput != null ? labelingJobOutput.build() : null;
        }

        @Override
        public final Builder labelingJobOutput(LabelingJobOutput labelingJobOutput) {
            this.labelingJobOutput = labelingJobOutput;
            return this;
        }

        public final LabelingJobInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(LabelingJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(LabelingJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public LabelingJobSummary build() {
            return new LabelingJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobSummary> {
        public Builder labelingJobName(String var1);

        public Builder labelingJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder labelingJobStatus(String var1);

        public Builder labelingJobStatus(LabelingJobStatus var1);

        public Builder labelCounters(LabelCounters var1);

        default public Builder labelCounters(Consumer<LabelCounters.Builder> labelCounters) {
            return this.labelCounters((LabelCounters)((LabelCounters.Builder)LabelCounters.builder().applyMutation(labelCounters)).build());
        }

        public Builder workteamArn(String var1);

        public Builder preHumanTaskLambdaArn(String var1);

        public Builder annotationConsolidationLambdaArn(String var1);

        public Builder failureReason(String var1);

        public Builder labelingJobOutput(LabelingJobOutput var1);

        default public Builder labelingJobOutput(Consumer<LabelingJobOutput.Builder> labelingJobOutput) {
            return this.labelingJobOutput((LabelingJobOutput)((LabelingJobOutput.Builder)LabelingJobOutput.builder().applyMutation(labelingJobOutput)).build());
        }

        public Builder inputConfig(LabelingJobInputConfig var1);

        default public Builder inputConfig(Consumer<LabelingJobInputConfig.Builder> inputConfig) {
            return this.inputConfig((LabelingJobInputConfig)((LabelingJobInputConfig.Builder)LabelingJobInputConfig.builder().applyMutation(inputConfig)).build());
        }
    }
}

