/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelQualityAppSpecification;
import software.amazon.awssdk.services.sagemaker.model.ModelQualityBaselineConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelQualityJobInput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringResources;
import software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelQualityJobDefinitionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateModelQualityJobDefinitionRequest> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinitionName").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::jobDefinitionName)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::jobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()}).build();
    private static final SdkField<ModelQualityBaselineConfig> MODEL_QUALITY_BASELINE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQualityBaselineConfig").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::modelQualityBaselineConfig)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::modelQualityBaselineConfig)).constructor(ModelQualityBaselineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityBaselineConfig").build()}).build();
    private static final SdkField<ModelQualityAppSpecification> MODEL_QUALITY_APP_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQualityAppSpecification").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::modelQualityAppSpecification)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::modelQualityAppSpecification)).constructor(ModelQualityAppSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityAppSpecification").build()}).build();
    private static final SdkField<ModelQualityJobInput> MODEL_QUALITY_JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQualityJobInput").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::modelQualityJobInput)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::modelQualityJobInput)).constructor(ModelQualityJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityJobInput").build()}).build();
    private static final SdkField<MonitoringOutputConfig> MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQualityJobOutputConfig").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::modelQualityJobOutputConfig)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::modelQualityJobOutputConfig)).constructor(MonitoringOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityJobOutputConfig").build()}).build();
    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobResources").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::jobResources)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::jobResources)).constructor(MonitoringResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()}).build();
    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfig").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::networkConfig)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::networkConfig)).constructor(MonitoringNetworkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::roleArn)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::stoppingCondition)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::stoppingCondition)).constructor(MonitoringStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateModelQualityJobDefinitionRequest.getter(CreateModelQualityJobDefinitionRequest::tags)).setter(CreateModelQualityJobDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD, MODEL_QUALITY_BASELINE_CONFIG_FIELD, MODEL_QUALITY_APP_SPECIFICATION_FIELD, MODEL_QUALITY_JOB_INPUT_FIELD, MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JobDefinitionName", JOB_DEFINITION_NAME_FIELD);
            this.put("ModelQualityBaselineConfig", MODEL_QUALITY_BASELINE_CONFIG_FIELD);
            this.put("ModelQualityAppSpecification", MODEL_QUALITY_APP_SPECIFICATION_FIELD);
            this.put("ModelQualityJobInput", MODEL_QUALITY_JOB_INPUT_FIELD);
            this.put("ModelQualityJobOutputConfig", MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD);
            this.put("JobResources", JOB_RESOURCES_FIELD);
            this.put("NetworkConfig", NETWORK_CONFIG_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("StoppingCondition", STOPPING_CONDITION_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String jobDefinitionName;
    private final ModelQualityBaselineConfig modelQualityBaselineConfig;
    private final ModelQualityAppSpecification modelQualityAppSpecification;
    private final ModelQualityJobInput modelQualityJobInput;
    private final MonitoringOutputConfig modelQualityJobOutputConfig;
    private final MonitoringResources jobResources;
    private final MonitoringNetworkConfig networkConfig;
    private final String roleArn;
    private final MonitoringStoppingCondition stoppingCondition;
    private final List<Tag> tags;

    private CreateModelQualityJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.modelQualityBaselineConfig = builder.modelQualityBaselineConfig;
        this.modelQualityAppSpecification = builder.modelQualityAppSpecification;
        this.modelQualityJobInput = builder.modelQualityJobInput;
        this.modelQualityJobOutputConfig = builder.modelQualityJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    public final String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public final ModelQualityBaselineConfig modelQualityBaselineConfig() {
        return this.modelQualityBaselineConfig;
    }

    public final ModelQualityAppSpecification modelQualityAppSpecification() {
        return this.modelQualityAppSpecification;
    }

    public final ModelQualityJobInput modelQualityJobInput() {
        return this.modelQualityJobInput;
    }

    public final MonitoringOutputConfig modelQualityJobOutputConfig() {
        return this.modelQualityJobOutputConfig;
    }

    public final MonitoringResources jobResources() {
        return this.jobResources;
    }

    public final MonitoringNetworkConfig networkConfig() {
        return this.networkConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final MonitoringStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelQualityJobDefinitionRequest)) {
            return false;
        }
        CreateModelQualityJobDefinitionRequest other = (CreateModelQualityJobDefinitionRequest)((Object)obj);
        return Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.modelQualityBaselineConfig(), other.modelQualityBaselineConfig()) && Objects.equals(this.modelQualityAppSpecification(), other.modelQualityAppSpecification()) && Objects.equals(this.modelQualityJobInput(), other.modelQualityJobInput()) && Objects.equals(this.modelQualityJobOutputConfig(), other.modelQualityJobOutputConfig()) && Objects.equals(this.jobResources(), other.jobResources()) && Objects.equals(this.networkConfig(), other.networkConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelQualityJobDefinitionRequest").add("JobDefinitionName", (Object)this.jobDefinitionName()).add("ModelQualityBaselineConfig", (Object)this.modelQualityBaselineConfig()).add("ModelQualityAppSpecification", (Object)this.modelQualityAppSpecification()).add("ModelQualityJobInput", (Object)this.modelQualityJobInput()).add("ModelQualityJobOutputConfig", (Object)this.modelQualityJobOutputConfig()).add("JobResources", (Object)this.jobResources()).add("NetworkConfig", (Object)this.networkConfig()).add("RoleArn", (Object)this.roleArn()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "ModelQualityBaselineConfig": {
                return Optional.ofNullable(clazz.cast(this.modelQualityBaselineConfig()));
            }
            case "ModelQualityAppSpecification": {
                return Optional.ofNullable(clazz.cast(this.modelQualityAppSpecification()));
            }
            case "ModelQualityJobInput": {
                return Optional.ofNullable(clazz.cast(this.modelQualityJobInput()));
            }
            case "ModelQualityJobOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.modelQualityJobOutputConfig()));
            }
            case "JobResources": {
                return Optional.ofNullable(clazz.cast(this.jobResources()));
            }
            case "NetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.networkConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelQualityJobDefinitionRequest, T> g) {
        return obj -> g.apply((CreateModelQualityJobDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private ModelQualityBaselineConfig modelQualityBaselineConfig;
        private ModelQualityAppSpecification modelQualityAppSpecification;
        private ModelQualityJobInput modelQualityJobInput;
        private MonitoringOutputConfig modelQualityJobOutputConfig;
        private MonitoringResources jobResources;
        private MonitoringNetworkConfig networkConfig;
        private String roleArn;
        private MonitoringStoppingCondition stoppingCondition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelQualityJobDefinitionRequest model) {
            super(model);
            this.jobDefinitionName(model.jobDefinitionName);
            this.modelQualityBaselineConfig(model.modelQualityBaselineConfig);
            this.modelQualityAppSpecification(model.modelQualityAppSpecification);
            this.modelQualityJobInput(model.modelQualityJobInput);
            this.modelQualityJobOutputConfig(model.modelQualityJobOutputConfig);
            this.jobResources(model.jobResources);
            this.networkConfig(model.networkConfig);
            this.roleArn(model.roleArn);
            this.stoppingCondition(model.stoppingCondition);
            this.tags(model.tags);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final ModelQualityBaselineConfig.Builder getModelQualityBaselineConfig() {
            return this.modelQualityBaselineConfig != null ? this.modelQualityBaselineConfig.toBuilder() : null;
        }

        public final void setModelQualityBaselineConfig(ModelQualityBaselineConfig.BuilderImpl modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig != null ? modelQualityBaselineConfig.build() : null;
        }

        @Override
        public final Builder modelQualityBaselineConfig(ModelQualityBaselineConfig modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig;
            return this;
        }

        public final ModelQualityAppSpecification.Builder getModelQualityAppSpecification() {
            return this.modelQualityAppSpecification != null ? this.modelQualityAppSpecification.toBuilder() : null;
        }

        public final void setModelQualityAppSpecification(ModelQualityAppSpecification.BuilderImpl modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification != null ? modelQualityAppSpecification.build() : null;
        }

        @Override
        public final Builder modelQualityAppSpecification(ModelQualityAppSpecification modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification;
            return this;
        }

        public final ModelQualityJobInput.Builder getModelQualityJobInput() {
            return this.modelQualityJobInput != null ? this.modelQualityJobInput.toBuilder() : null;
        }

        public final void setModelQualityJobInput(ModelQualityJobInput.BuilderImpl modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput != null ? modelQualityJobInput.build() : null;
        }

        @Override
        public final Builder modelQualityJobInput(ModelQualityJobInput modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput;
            return this;
        }

        public final MonitoringOutputConfig.Builder getModelQualityJobOutputConfig() {
            return this.modelQualityJobOutputConfig != null ? this.modelQualityJobOutputConfig.toBuilder() : null;
        }

        public final void setModelQualityJobOutputConfig(MonitoringOutputConfig.BuilderImpl modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig != null ? modelQualityJobOutputConfig.build() : null;
        }

        @Override
        public final Builder modelQualityJobOutputConfig(MonitoringOutputConfig modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig;
            return this;
        }

        public final MonitoringResources.Builder getJobResources() {
            return this.jobResources != null ? this.jobResources.toBuilder() : null;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return this.networkConfig != null ? this.networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelQualityJobDefinitionRequest build() {
            return new CreateModelQualityJobDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelQualityJobDefinitionRequest> {
        public Builder jobDefinitionName(String var1);

        public Builder modelQualityBaselineConfig(ModelQualityBaselineConfig var1);

        default public Builder modelQualityBaselineConfig(Consumer<ModelQualityBaselineConfig.Builder> modelQualityBaselineConfig) {
            return this.modelQualityBaselineConfig((ModelQualityBaselineConfig)((ModelQualityBaselineConfig.Builder)ModelQualityBaselineConfig.builder().applyMutation(modelQualityBaselineConfig)).build());
        }

        public Builder modelQualityAppSpecification(ModelQualityAppSpecification var1);

        default public Builder modelQualityAppSpecification(Consumer<ModelQualityAppSpecification.Builder> modelQualityAppSpecification) {
            return this.modelQualityAppSpecification((ModelQualityAppSpecification)((ModelQualityAppSpecification.Builder)ModelQualityAppSpecification.builder().applyMutation(modelQualityAppSpecification)).build());
        }

        public Builder modelQualityJobInput(ModelQualityJobInput var1);

        default public Builder modelQualityJobInput(Consumer<ModelQualityJobInput.Builder> modelQualityJobInput) {
            return this.modelQualityJobInput((ModelQualityJobInput)((ModelQualityJobInput.Builder)ModelQualityJobInput.builder().applyMutation(modelQualityJobInput)).build());
        }

        public Builder modelQualityJobOutputConfig(MonitoringOutputConfig var1);

        default public Builder modelQualityJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> modelQualityJobOutputConfig) {
            return this.modelQualityJobOutputConfig((MonitoringOutputConfig)((MonitoringOutputConfig.Builder)MonitoringOutputConfig.builder().applyMutation(modelQualityJobOutputConfig)).build());
        }

        public Builder jobResources(MonitoringResources var1);

        default public Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return this.jobResources((MonitoringResources)((MonitoringResources.Builder)MonitoringResources.builder().applyMutation(jobResources)).build());
        }

        public Builder networkConfig(MonitoringNetworkConfig var1);

        default public Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return this.networkConfig((MonitoringNetworkConfig)((MonitoringNetworkConfig.Builder)MonitoringNetworkConfig.builder().applyMutation(networkConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder stoppingCondition(MonitoringStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((MonitoringStoppingCondition)((MonitoringStoppingCondition.Builder)MonitoringStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

