/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOptimizationJobsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListOptimizationJobsResponse> {
    private static final SdkField<List<OptimizationJobSummary>> OPTIMIZATION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptimizationJobSummaries").getter(ListOptimizationJobsResponse.getter(ListOptimizationJobsResponse::optimizationJobSummaries)).setter(ListOptimizationJobsResponse.setter(Builder::optimizationJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptimizationJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOptimizationJobsResponse.getter(ListOptimizationJobsResponse::nextToken)).setter(ListOptimizationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIMIZATION_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<OptimizationJobSummary> optimizationJobSummaries;
    private final String nextToken;

    private ListOptimizationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.optimizationJobSummaries = builder.optimizationJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOptimizationJobSummaries() {
        return this.optimizationJobSummaries != null && !(this.optimizationJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<OptimizationJobSummary> optimizationJobSummaries() {
        return this.optimizationJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptimizationJobSummaries() ? this.optimizationJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOptimizationJobsResponse)) {
            return false;
        }
        ListOptimizationJobsResponse other = (ListOptimizationJobsResponse)((Object)obj);
        return this.hasOptimizationJobSummaries() == other.hasOptimizationJobSummaries() && Objects.equals(this.optimizationJobSummaries(), other.optimizationJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOptimizationJobsResponse").add("OptimizationJobSummaries", this.hasOptimizationJobSummaries() ? this.optimizationJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptimizationJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.optimizationJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOptimizationJobsResponse, T> g) {
        return obj -> g.apply((ListOptimizationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<OptimizationJobSummary> optimizationJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOptimizationJobsResponse model) {
            super(model);
            this.optimizationJobSummaries(model.optimizationJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<OptimizationJobSummary.Builder> getOptimizationJobSummaries() {
            List<OptimizationJobSummary.Builder> result = OptimizationJobSummariesCopier.copyToBuilder(this.optimizationJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptimizationJobSummaries(Collection<OptimizationJobSummary.BuilderImpl> optimizationJobSummaries) {
            this.optimizationJobSummaries = OptimizationJobSummariesCopier.copyFromBuilder(optimizationJobSummaries);
        }

        @Override
        public final Builder optimizationJobSummaries(Collection<OptimizationJobSummary> optimizationJobSummaries) {
            this.optimizationJobSummaries = OptimizationJobSummariesCopier.copy(optimizationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationJobSummaries(OptimizationJobSummary ... optimizationJobSummaries) {
            this.optimizationJobSummaries(Arrays.asList(optimizationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationJobSummaries(Consumer<OptimizationJobSummary.Builder> ... optimizationJobSummaries) {
            this.optimizationJobSummaries(Stream.of(optimizationJobSummaries).map(c -> (OptimizationJobSummary)((OptimizationJobSummary.Builder)OptimizationJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOptimizationJobsResponse build() {
            return new ListOptimizationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOptimizationJobsResponse> {
        public Builder optimizationJobSummaries(Collection<OptimizationJobSummary> var1);

        public Builder optimizationJobSummaries(OptimizationJobSummary ... var1);

        public Builder optimizationJobSummaries(Consumer<OptimizationJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

