/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.Edge;
import software.amazon.awssdk.services.sagemaker.model.EdgesCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.Vertex;
import software.amazon.awssdk.services.sagemaker.model.VerticesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryLineageResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, QueryLineageResponse> {
    private static final SdkField<List<Vertex>> VERTICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Vertices").getter(QueryLineageResponse.getter(QueryLineageResponse::vertices)).setter(QueryLineageResponse.setter(Builder::vertices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vertices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Vertex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Edge>> EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Edges").getter(QueryLineageResponse.getter(QueryLineageResponse::edges)).setter(QueryLineageResponse.setter(Builder::edges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Edge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(QueryLineageResponse.getter(QueryLineageResponse::nextToken)).setter(QueryLineageResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERTICES_FIELD, EDGES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Vertex> vertices;
    private final List<Edge> edges;
    private final String nextToken;

    private QueryLineageResponse(BuilderImpl builder) {
        super(builder);
        this.vertices = builder.vertices;
        this.edges = builder.edges;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVertices() {
        return this.vertices != null && !(this.vertices instanceof SdkAutoConstructList);
    }

    public final List<Vertex> vertices() {
        return this.vertices;
    }

    public final boolean hasEdges() {
        return this.edges != null && !(this.edges instanceof SdkAutoConstructList);
    }

    public final List<Edge> edges() {
        return this.edges;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVertices() ? this.vertices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdges() ? this.edges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryLineageResponse)) {
            return false;
        }
        QueryLineageResponse other = (QueryLineageResponse)((Object)obj);
        return this.hasVertices() == other.hasVertices() && Objects.equals(this.vertices(), other.vertices()) && this.hasEdges() == other.hasEdges() && Objects.equals(this.edges(), other.edges()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"QueryLineageResponse").add("Vertices", this.hasVertices() ? this.vertices() : null).add("Edges", this.hasEdges() ? this.edges() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Vertices": {
                return Optional.ofNullable(clazz.cast(this.vertices()));
            }
            case "Edges": {
                return Optional.ofNullable(clazz.cast(this.edges()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryLineageResponse, T> g) {
        return obj -> g.apply((QueryLineageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<Vertex> vertices = DefaultSdkAutoConstructList.getInstance();
        private List<Edge> edges = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryLineageResponse model) {
            super(model);
            this.vertices(model.vertices);
            this.edges(model.edges);
            this.nextToken(model.nextToken);
        }

        public final List<Vertex.Builder> getVertices() {
            List<Vertex.Builder> result = VerticesCopier.copyToBuilder(this.vertices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVertices(Collection<Vertex.BuilderImpl> vertices) {
            this.vertices = VerticesCopier.copyFromBuilder(vertices);
        }

        @Override
        public final Builder vertices(Collection<Vertex> vertices) {
            this.vertices = VerticesCopier.copy(vertices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vertices(Vertex ... vertices) {
            this.vertices(Arrays.asList(vertices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vertices(Consumer<Vertex.Builder> ... vertices) {
            this.vertices(Stream.of(vertices).map(c -> (Vertex)((Vertex.Builder)Vertex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Edge.Builder> getEdges() {
            List<Edge.Builder> result = EdgesCopier.copyToBuilder(this.edges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdges(Collection<Edge.BuilderImpl> edges) {
            this.edges = EdgesCopier.copyFromBuilder(edges);
        }

        @Override
        public final Builder edges(Collection<Edge> edges) {
            this.edges = EdgesCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Edge ... edges) {
            this.edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<Edge.Builder> ... edges) {
            this.edges(Stream.of(edges).map(c -> (Edge)((Edge.Builder)Edge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public QueryLineageResponse build() {
            return new QueryLineageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryLineageResponse> {
        public Builder vertices(Collection<Vertex> var1);

        public Builder vertices(Vertex ... var1);

        public Builder vertices(Consumer<Vertex.Builder> ... var1);

        public Builder edges(Collection<Edge> var1);

        public Builder edges(Edge ... var1);

        public Builder edges(Consumer<Edge.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

