/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.OptimizationConfig;
import software.amazon.awssdk.services.sagemaker.model.OptimizationConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobDeploymentInstanceType;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobEnvironmentVariablesCopier;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobModelSource;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.OptimizationVpcConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOptimizationJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateOptimizationJobRequest> {
    private static final SdkField<String> OPTIMIZATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationJobName").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::optimizationJobName)).setter(CreateOptimizationJobRequest.setter(Builder::optimizationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::roleArn)).setter(CreateOptimizationJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<OptimizationJobModelSource> MODEL_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelSource").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::modelSource)).setter(CreateOptimizationJobRequest.setter(Builder::modelSource)).constructor(OptimizationJobModelSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSource").build()}).build();
    private static final SdkField<String> DEPLOYMENT_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentInstanceType").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::deploymentInstanceTypeAsString)).setter(CreateOptimizationJobRequest.setter(Builder::deploymentInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentInstanceType").build()}).build();
    private static final SdkField<Map<String, String>> OPTIMIZATION_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OptimizationEnvironment").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::optimizationEnvironment)).setter(CreateOptimizationJobRequest.setter(Builder::optimizationEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationEnvironment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<OptimizationConfig>> OPTIMIZATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptimizationConfigs").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::optimizationConfigs)).setter(CreateOptimizationJobRequest.setter(Builder::optimizationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptimizationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OptimizationJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::outputConfig)).setter(CreateOptimizationJobRequest.setter(Builder::outputConfig)).constructor(OptimizationJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::stoppingCondition)).setter(CreateOptimizationJobRequest.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::tags)).setter(CreateOptimizationJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OptimizationVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateOptimizationJobRequest.getter(CreateOptimizationJobRequest::vpcConfig)).setter(CreateOptimizationJobRequest.setter(Builder::vpcConfig)).constructor(OptimizationVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIMIZATION_JOB_NAME_FIELD, ROLE_ARN_FIELD, MODEL_SOURCE_FIELD, DEPLOYMENT_INSTANCE_TYPE_FIELD, OPTIMIZATION_ENVIRONMENT_FIELD, OPTIMIZATION_CONFIGS_FIELD, OUTPUT_CONFIG_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD, VPC_CONFIG_FIELD));
    private final String optimizationJobName;
    private final String roleArn;
    private final OptimizationJobModelSource modelSource;
    private final String deploymentInstanceType;
    private final Map<String, String> optimizationEnvironment;
    private final List<OptimizationConfig> optimizationConfigs;
    private final OptimizationJobOutputConfig outputConfig;
    private final StoppingCondition stoppingCondition;
    private final List<Tag> tags;
    private final OptimizationVpcConfig vpcConfig;

    private CreateOptimizationJobRequest(BuilderImpl builder) {
        super(builder);
        this.optimizationJobName = builder.optimizationJobName;
        this.roleArn = builder.roleArn;
        this.modelSource = builder.modelSource;
        this.deploymentInstanceType = builder.deploymentInstanceType;
        this.optimizationEnvironment = builder.optimizationEnvironment;
        this.optimizationConfigs = builder.optimizationConfigs;
        this.outputConfig = builder.outputConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
    }

    public final String optimizationJobName() {
        return this.optimizationJobName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final OptimizationJobModelSource modelSource() {
        return this.modelSource;
    }

    public final OptimizationJobDeploymentInstanceType deploymentInstanceType() {
        return OptimizationJobDeploymentInstanceType.fromValue(this.deploymentInstanceType);
    }

    public final String deploymentInstanceTypeAsString() {
        return this.deploymentInstanceType;
    }

    public final boolean hasOptimizationEnvironment() {
        return this.optimizationEnvironment != null && !(this.optimizationEnvironment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> optimizationEnvironment() {
        return this.optimizationEnvironment;
    }

    public final boolean hasOptimizationConfigs() {
        return this.optimizationConfigs != null && !(this.optimizationConfigs instanceof SdkAutoConstructList);
    }

    public final List<OptimizationConfig> optimizationConfigs() {
        return this.optimizationConfigs;
    }

    public final OptimizationJobOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final OptimizationVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptimizationEnvironment() ? this.optimizationEnvironment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptimizationConfigs() ? this.optimizationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOptimizationJobRequest)) {
            return false;
        }
        CreateOptimizationJobRequest other = (CreateOptimizationJobRequest)((Object)obj);
        return Objects.equals(this.optimizationJobName(), other.optimizationJobName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.modelSource(), other.modelSource()) && Objects.equals(this.deploymentInstanceTypeAsString(), other.deploymentInstanceTypeAsString()) && this.hasOptimizationEnvironment() == other.hasOptimizationEnvironment() && Objects.equals(this.optimizationEnvironment(), other.optimizationEnvironment()) && this.hasOptimizationConfigs() == other.hasOptimizationConfigs() && Objects.equals(this.optimizationConfigs(), other.optimizationConfigs()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOptimizationJobRequest").add("OptimizationJobName", (Object)this.optimizationJobName()).add("RoleArn", (Object)this.roleArn()).add("ModelSource", (Object)this.modelSource()).add("DeploymentInstanceType", (Object)this.deploymentInstanceTypeAsString()).add("OptimizationEnvironment", this.hasOptimizationEnvironment() ? this.optimizationEnvironment() : null).add("OptimizationConfigs", this.hasOptimizationConfigs() ? this.optimizationConfigs() : null).add("OutputConfig", (Object)this.outputConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Tags", this.hasTags() ? this.tags() : null).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptimizationJobName": {
                return Optional.ofNullable(clazz.cast(this.optimizationJobName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ModelSource": {
                return Optional.ofNullable(clazz.cast(this.modelSource()));
            }
            case "DeploymentInstanceType": {
                return Optional.ofNullable(clazz.cast(this.deploymentInstanceTypeAsString()));
            }
            case "OptimizationEnvironment": {
                return Optional.ofNullable(clazz.cast(this.optimizationEnvironment()));
            }
            case "OptimizationConfigs": {
                return Optional.ofNullable(clazz.cast(this.optimizationConfigs()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOptimizationJobRequest, T> g) {
        return obj -> g.apply((CreateOptimizationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String optimizationJobName;
        private String roleArn;
        private OptimizationJobModelSource modelSource;
        private String deploymentInstanceType;
        private Map<String, String> optimizationEnvironment = DefaultSdkAutoConstructMap.getInstance();
        private List<OptimizationConfig> optimizationConfigs = DefaultSdkAutoConstructList.getInstance();
        private OptimizationJobOutputConfig outputConfig;
        private StoppingCondition stoppingCondition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private OptimizationVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOptimizationJobRequest model) {
            super(model);
            this.optimizationJobName(model.optimizationJobName);
            this.roleArn(model.roleArn);
            this.modelSource(model.modelSource);
            this.deploymentInstanceType(model.deploymentInstanceType);
            this.optimizationEnvironment(model.optimizationEnvironment);
            this.optimizationConfigs(model.optimizationConfigs);
            this.outputConfig(model.outputConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.tags(model.tags);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getOptimizationJobName() {
            return this.optimizationJobName;
        }

        public final void setOptimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
        }

        @Override
        public final Builder optimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final OptimizationJobModelSource.Builder getModelSource() {
            return this.modelSource != null ? this.modelSource.toBuilder() : null;
        }

        public final void setModelSource(OptimizationJobModelSource.BuilderImpl modelSource) {
            this.modelSource = modelSource != null ? modelSource.build() : null;
        }

        @Override
        public final Builder modelSource(OptimizationJobModelSource modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        public final String getDeploymentInstanceType() {
            return this.deploymentInstanceType;
        }

        public final void setDeploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
        }

        @Override
        public final Builder deploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
            return this;
        }

        @Override
        public final Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType) {
            this.deploymentInstanceType(deploymentInstanceType == null ? null : deploymentInstanceType.toString());
            return this;
        }

        public final Map<String, String> getOptimizationEnvironment() {
            if (this.optimizationEnvironment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.optimizationEnvironment;
        }

        public final void setOptimizationEnvironment(Map<String, String> optimizationEnvironment) {
            this.optimizationEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(optimizationEnvironment);
        }

        @Override
        public final Builder optimizationEnvironment(Map<String, String> optimizationEnvironment) {
            this.optimizationEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(optimizationEnvironment);
            return this;
        }

        public final List<OptimizationConfig.Builder> getOptimizationConfigs() {
            List<OptimizationConfig.Builder> result = OptimizationConfigsCopier.copyToBuilder(this.optimizationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptimizationConfigs(Collection<OptimizationConfig.BuilderImpl> optimizationConfigs) {
            this.optimizationConfigs = OptimizationConfigsCopier.copyFromBuilder(optimizationConfigs);
        }

        @Override
        public final Builder optimizationConfigs(Collection<OptimizationConfig> optimizationConfigs) {
            this.optimizationConfigs = OptimizationConfigsCopier.copy(optimizationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationConfigs(OptimizationConfig ... optimizationConfigs) {
            this.optimizationConfigs(Arrays.asList(optimizationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationConfigs(Consumer<OptimizationConfig.Builder> ... optimizationConfigs) {
            this.optimizationConfigs(Stream.of(optimizationConfigs).map(c -> (OptimizationConfig)((OptimizationConfig.Builder)OptimizationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OptimizationJobOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OptimizationJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OptimizationJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OptimizationVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(OptimizationVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(OptimizationVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOptimizationJobRequest build() {
            return new CreateOptimizationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOptimizationJobRequest> {
        public Builder optimizationJobName(String var1);

        public Builder roleArn(String var1);

        public Builder modelSource(OptimizationJobModelSource var1);

        default public Builder modelSource(Consumer<OptimizationJobModelSource.Builder> modelSource) {
            return this.modelSource((OptimizationJobModelSource)((OptimizationJobModelSource.Builder)OptimizationJobModelSource.builder().applyMutation(modelSource)).build());
        }

        public Builder deploymentInstanceType(String var1);

        public Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType var1);

        public Builder optimizationEnvironment(Map<String, String> var1);

        public Builder optimizationConfigs(Collection<OptimizationConfig> var1);

        public Builder optimizationConfigs(OptimizationConfig ... var1);

        public Builder optimizationConfigs(Consumer<OptimizationConfig.Builder> ... var1);

        public Builder outputConfig(OptimizationJobOutputConfig var1);

        default public Builder outputConfig(Consumer<OptimizationJobOutputConfig.Builder> outputConfig) {
            return this.outputConfig((OptimizationJobOutputConfig)((OptimizationJobOutputConfig.Builder)OptimizationJobOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder vpcConfig(OptimizationVpcConfig var1);

        default public Builder vpcConfig(Consumer<OptimizationVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((OptimizationVpcConfig)((OptimizationVpcConfig.Builder)OptimizationVpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

