/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ResourceSpec;
import software.amazon.awssdk.services.sagemaker.model.SpaceAppLifecycleManagement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpaceCodeEditorAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpaceCodeEditorAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultResourceSpec").getter(SpaceCodeEditorAppSettings.getter(SpaceCodeEditorAppSettings::defaultResourceSpec)).setter(SpaceCodeEditorAppSettings.setter(Builder::defaultResourceSpec)).constructor(ResourceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build()}).build();
    private static final SdkField<SpaceAppLifecycleManagement> APP_LIFECYCLE_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppLifecycleManagement").getter(SpaceCodeEditorAppSettings.getter(SpaceCodeEditorAppSettings::appLifecycleManagement)).setter(SpaceCodeEditorAppSettings.setter(Builder::appLifecycleManagement)).constructor(SpaceAppLifecycleManagement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLifecycleManagement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD, APP_LIFECYCLE_MANAGEMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourceSpec defaultResourceSpec;
    private final SpaceAppLifecycleManagement appLifecycleManagement;

    private SpaceCodeEditorAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.appLifecycleManagement = builder.appLifecycleManagement;
    }

    public final ResourceSpec defaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public final SpaceAppLifecycleManagement appLifecycleManagement() {
        return this.appLifecycleManagement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.appLifecycleManagement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceCodeEditorAppSettings)) {
            return false;
        }
        SpaceCodeEditorAppSettings other = (SpaceCodeEditorAppSettings)obj;
        return Objects.equals(this.defaultResourceSpec(), other.defaultResourceSpec()) && Objects.equals(this.appLifecycleManagement(), other.appLifecycleManagement());
    }

    public final String toString() {
        return ToString.builder((String)"SpaceCodeEditorAppSettings").add("DefaultResourceSpec", (Object)this.defaultResourceSpec()).add("AppLifecycleManagement", (Object)this.appLifecycleManagement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultResourceSpec": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceSpec()));
            }
            case "AppLifecycleManagement": {
                return Optional.ofNullable(clazz.cast(this.appLifecycleManagement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpaceCodeEditorAppSettings, T> g) {
        return obj -> g.apply((SpaceCodeEditorAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceSpec defaultResourceSpec;
        private SpaceAppLifecycleManagement appLifecycleManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceCodeEditorAppSettings model) {
            this.defaultResourceSpec(model.defaultResourceSpec);
            this.appLifecycleManagement(model.appLifecycleManagement);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return this.defaultResourceSpec != null ? this.defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final SpaceAppLifecycleManagement.Builder getAppLifecycleManagement() {
            return this.appLifecycleManagement != null ? this.appLifecycleManagement.toBuilder() : null;
        }

        public final void setAppLifecycleManagement(SpaceAppLifecycleManagement.BuilderImpl appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement != null ? appLifecycleManagement.build() : null;
        }

        @Override
        public final Builder appLifecycleManagement(SpaceAppLifecycleManagement appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement;
            return this;
        }

        public SpaceCodeEditorAppSettings build() {
            return new SpaceCodeEditorAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpaceCodeEditorAppSettings> {
        public Builder defaultResourceSpec(ResourceSpec var1);

        default public Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return this.defaultResourceSpec((ResourceSpec)((ResourceSpec.Builder)ResourceSpec.builder().applyMutation(defaultResourceSpec)).build());
        }

        public Builder appLifecycleManagement(SpaceAppLifecycleManagement var1);

        default public Builder appLifecycleManagement(Consumer<SpaceAppLifecycleManagement.Builder> appLifecycleManagement) {
            return this.appLifecycleManagement((SpaceAppLifecycleManagement)((SpaceAppLifecycleManagement.Builder)SpaceAppLifecycleManagement.builder().applyMutation(appLifecycleManagement)).build());
        }
    }
}

