/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AppType;
import software.amazon.awssdk.services.sagemaker.model.SpaceStorageSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpaceSettingsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpaceSettingsSummary> {
    private static final SdkField<String> APP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppType").getter(SpaceSettingsSummary.getter(SpaceSettingsSummary::appTypeAsString)).setter(SpaceSettingsSummary.setter(Builder::appType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()}).build();
    private static final SdkField<SpaceStorageSettings> SPACE_STORAGE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceStorageSettings").getter(SpaceSettingsSummary.getter(SpaceSettingsSummary::spaceStorageSettings)).setter(SpaceSettingsSummary.setter(Builder::spaceStorageSettings)).constructor(SpaceStorageSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceStorageSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_TYPE_FIELD, SPACE_STORAGE_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appType;
    private final SpaceStorageSettings spaceStorageSettings;

    private SpaceSettingsSummary(BuilderImpl builder) {
        this.appType = builder.appType;
        this.spaceStorageSettings = builder.spaceStorageSettings;
    }

    public final AppType appType() {
        return AppType.fromValue(this.appType);
    }

    public final String appTypeAsString() {
        return this.appType;
    }

    public final SpaceStorageSettings spaceStorageSettings() {
        return this.spaceStorageSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceStorageSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceSettingsSummary)) {
            return false;
        }
        SpaceSettingsSummary other = (SpaceSettingsSummary)obj;
        return Objects.equals(this.appTypeAsString(), other.appTypeAsString()) && Objects.equals(this.spaceStorageSettings(), other.spaceStorageSettings());
    }

    public final String toString() {
        return ToString.builder((String)"SpaceSettingsSummary").add("AppType", (Object)this.appTypeAsString()).add("SpaceStorageSettings", (Object)this.spaceStorageSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppType": {
                return Optional.ofNullable(clazz.cast(this.appTypeAsString()));
            }
            case "SpaceStorageSettings": {
                return Optional.ofNullable(clazz.cast(this.spaceStorageSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpaceSettingsSummary, T> g) {
        return obj -> g.apply((SpaceSettingsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appType;
        private SpaceStorageSettings spaceStorageSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceSettingsSummary model) {
            this.appType(model.appType);
            this.spaceStorageSettings(model.spaceStorageSettings);
        }

        public final String getAppType() {
            return this.appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final SpaceStorageSettings.Builder getSpaceStorageSettings() {
            return this.spaceStorageSettings != null ? this.spaceStorageSettings.toBuilder() : null;
        }

        public final void setSpaceStorageSettings(SpaceStorageSettings.BuilderImpl spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings != null ? spaceStorageSettings.build() : null;
        }

        @Override
        public final Builder spaceStorageSettings(SpaceStorageSettings spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings;
            return this;
        }

        public SpaceSettingsSummary build() {
            return new SpaceSettingsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpaceSettingsSummary> {
        public Builder appType(String var1);

        public Builder appType(AppType var1);

        public Builder spaceStorageSettings(SpaceStorageSettings var1);

        default public Builder spaceStorageSettings(Consumer<SpaceStorageSettings.Builder> spaceStorageSettings) {
            return this.spaceStorageSettings((SpaceStorageSettings)((SpaceStorageSettings.Builder)SpaceStorageSettings.builder().applyMutation(spaceStorageSettings)).build());
        }
    }
}

