/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MlTools {
    DATA_WRANGLER("DataWrangler"),
    FEATURE_STORE("FeatureStore"),
    EMR_CLUSTERS("EmrClusters"),
    AUTO_ML("AutoMl"),
    EXPERIMENTS("Experiments"),
    TRAINING("Training"),
    MODEL_EVALUATION("ModelEvaluation"),
    PIPELINES("Pipelines"),
    MODELS("Models"),
    JUMP_START("JumpStart"),
    INFERENCE_RECOMMENDER("InferenceRecommender"),
    ENDPOINTS("Endpoints"),
    PROJECTS("Projects"),
    INFERENCE_OPTIMIZATION("InferenceOptimization"),
    PERFORMANCE_EVALUATION("PerformanceEvaluation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MlTools> VALUE_MAP;
    private final String value;

    private MlTools(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MlTools fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MlTools> knownValues() {
        EnumSet<MlTools> knownValues = EnumSet.allOf(MlTools.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MlTools.class, MlTools::toString);
    }
}

