/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AppLifecycleManagement;
import software.amazon.awssdk.services.sagemaker.model.CodeRepositoriesCopier;
import software.amazon.awssdk.services.sagemaker.model.CodeRepository;
import software.amazon.awssdk.services.sagemaker.model.CustomImage;
import software.amazon.awssdk.services.sagemaker.model.CustomImagesCopier;
import software.amazon.awssdk.services.sagemaker.model.EmrSettings;
import software.amazon.awssdk.services.sagemaker.model.LifecycleConfigArnsCopier;
import software.amazon.awssdk.services.sagemaker.model.ResourceSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JupyterLabAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JupyterLabAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultResourceSpec").getter(JupyterLabAppSettings.getter(JupyterLabAppSettings::defaultResourceSpec)).setter(JupyterLabAppSettings.setter(Builder::defaultResourceSpec)).constructor(ResourceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build()}).build();
    private static final SdkField<List<CustomImage>> CUSTOM_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomImages").getter(JupyterLabAppSettings.getter(JupyterLabAppSettings::customImages)).setter(JupyterLabAppSettings.setter(Builder::customImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LIFECYCLE_CONFIG_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifecycleConfigArns").getter(JupyterLabAppSettings.getter(JupyterLabAppSettings::lifecycleConfigArns)).setter(JupyterLabAppSettings.setter(Builder::lifecycleConfigArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CodeRepository>> CODE_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CodeRepositories").getter(JupyterLabAppSettings.getter(JupyterLabAppSettings::codeRepositories)).setter(JupyterLabAppSettings.setter(Builder::codeRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AppLifecycleManagement> APP_LIFECYCLE_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppLifecycleManagement").getter(JupyterLabAppSettings.getter(JupyterLabAppSettings::appLifecycleManagement)).setter(JupyterLabAppSettings.setter(Builder::appLifecycleManagement)).constructor(AppLifecycleManagement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLifecycleManagement").build()}).build();
    private static final SdkField<EmrSettings> EMR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmrSettings").getter(JupyterLabAppSettings.getter(JupyterLabAppSettings::emrSettings)).setter(JupyterLabAppSettings.setter(Builder::emrSettings)).constructor(EmrSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmrSettings").build()}).build();
    private static final SdkField<String> BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuiltInLifecycleConfigArn").getter(JupyterLabAppSettings.getter(JupyterLabAppSettings::builtInLifecycleConfigArn)).setter(JupyterLabAppSettings.setter(Builder::builtInLifecycleConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuiltInLifecycleConfigArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD, CUSTOM_IMAGES_FIELD, LIFECYCLE_CONFIG_ARNS_FIELD, CODE_REPOSITORIES_FIELD, APP_LIFECYCLE_MANAGEMENT_FIELD, EMR_SETTINGS_FIELD, BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourceSpec defaultResourceSpec;
    private final List<CustomImage> customImages;
    private final List<String> lifecycleConfigArns;
    private final List<CodeRepository> codeRepositories;
    private final AppLifecycleManagement appLifecycleManagement;
    private final EmrSettings emrSettings;
    private final String builtInLifecycleConfigArn;

    private JupyterLabAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.customImages = builder.customImages;
        this.lifecycleConfigArns = builder.lifecycleConfigArns;
        this.codeRepositories = builder.codeRepositories;
        this.appLifecycleManagement = builder.appLifecycleManagement;
        this.emrSettings = builder.emrSettings;
        this.builtInLifecycleConfigArn = builder.builtInLifecycleConfigArn;
    }

    public final ResourceSpec defaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public final boolean hasCustomImages() {
        return this.customImages != null && !(this.customImages instanceof SdkAutoConstructList);
    }

    public final List<CustomImage> customImages() {
        return this.customImages;
    }

    public final boolean hasLifecycleConfigArns() {
        return this.lifecycleConfigArns != null && !(this.lifecycleConfigArns instanceof SdkAutoConstructList);
    }

    public final List<String> lifecycleConfigArns() {
        return this.lifecycleConfigArns;
    }

    public final boolean hasCodeRepositories() {
        return this.codeRepositories != null && !(this.codeRepositories instanceof SdkAutoConstructList);
    }

    public final List<CodeRepository> codeRepositories() {
        return this.codeRepositories;
    }

    public final AppLifecycleManagement appLifecycleManagement() {
        return this.appLifecycleManagement;
    }

    public final EmrSettings emrSettings() {
        return this.emrSettings;
    }

    public final String builtInLifecycleConfigArn() {
        return this.builtInLifecycleConfigArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomImages() ? this.customImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleConfigArns() ? this.lifecycleConfigArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodeRepositories() ? this.codeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appLifecycleManagement());
        hashCode = 31 * hashCode + Objects.hashCode(this.emrSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.builtInLifecycleConfigArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JupyterLabAppSettings)) {
            return false;
        }
        JupyterLabAppSettings other = (JupyterLabAppSettings)obj;
        return Objects.equals(this.defaultResourceSpec(), other.defaultResourceSpec()) && this.hasCustomImages() == other.hasCustomImages() && Objects.equals(this.customImages(), other.customImages()) && this.hasLifecycleConfigArns() == other.hasLifecycleConfigArns() && Objects.equals(this.lifecycleConfigArns(), other.lifecycleConfigArns()) && this.hasCodeRepositories() == other.hasCodeRepositories() && Objects.equals(this.codeRepositories(), other.codeRepositories()) && Objects.equals(this.appLifecycleManagement(), other.appLifecycleManagement()) && Objects.equals(this.emrSettings(), other.emrSettings()) && Objects.equals(this.builtInLifecycleConfigArn(), other.builtInLifecycleConfigArn());
    }

    public final String toString() {
        return ToString.builder((String)"JupyterLabAppSettings").add("DefaultResourceSpec", (Object)this.defaultResourceSpec()).add("CustomImages", this.hasCustomImages() ? this.customImages() : null).add("LifecycleConfigArns", this.hasLifecycleConfigArns() ? this.lifecycleConfigArns() : null).add("CodeRepositories", this.hasCodeRepositories() ? this.codeRepositories() : null).add("AppLifecycleManagement", (Object)this.appLifecycleManagement()).add("EmrSettings", (Object)this.emrSettings()).add("BuiltInLifecycleConfigArn", (Object)this.builtInLifecycleConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultResourceSpec": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceSpec()));
            }
            case "CustomImages": {
                return Optional.ofNullable(clazz.cast(this.customImages()));
            }
            case "LifecycleConfigArns": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfigArns()));
            }
            case "CodeRepositories": {
                return Optional.ofNullable(clazz.cast(this.codeRepositories()));
            }
            case "AppLifecycleManagement": {
                return Optional.ofNullable(clazz.cast(this.appLifecycleManagement()));
            }
            case "EmrSettings": {
                return Optional.ofNullable(clazz.cast(this.emrSettings()));
            }
            case "BuiltInLifecycleConfigArn": {
                return Optional.ofNullable(clazz.cast(this.builtInLifecycleConfigArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JupyterLabAppSettings, T> g) {
        return obj -> g.apply((JupyterLabAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceSpec defaultResourceSpec;
        private List<CustomImage> customImages = DefaultSdkAutoConstructList.getInstance();
        private List<String> lifecycleConfigArns = DefaultSdkAutoConstructList.getInstance();
        private List<CodeRepository> codeRepositories = DefaultSdkAutoConstructList.getInstance();
        private AppLifecycleManagement appLifecycleManagement;
        private EmrSettings emrSettings;
        private String builtInLifecycleConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JupyterLabAppSettings model) {
            this.defaultResourceSpec(model.defaultResourceSpec);
            this.customImages(model.customImages);
            this.lifecycleConfigArns(model.lifecycleConfigArns);
            this.codeRepositories(model.codeRepositories);
            this.appLifecycleManagement(model.appLifecycleManagement);
            this.emrSettings(model.emrSettings);
            this.builtInLifecycleConfigArn(model.builtInLifecycleConfigArn);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return this.defaultResourceSpec != null ? this.defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final List<CustomImage.Builder> getCustomImages() {
            List<CustomImage.Builder> result = CustomImagesCopier.copyToBuilder(this.customImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomImages(Collection<CustomImage.BuilderImpl> customImages) {
            this.customImages = CustomImagesCopier.copyFromBuilder(customImages);
        }

        @Override
        public final Builder customImages(Collection<CustomImage> customImages) {
            this.customImages = CustomImagesCopier.copy(customImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(CustomImage ... customImages) {
            this.customImages(Arrays.asList(customImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(Consumer<CustomImage.Builder> ... customImages) {
            this.customImages(Stream.of(customImages).map(c -> (CustomImage)((CustomImage.Builder)CustomImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getLifecycleConfigArns() {
            if (this.lifecycleConfigArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifecycleConfigArns;
        }

        public final void setLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
        }

        @Override
        public final Builder lifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleConfigArns(String ... lifecycleConfigArns) {
            this.lifecycleConfigArns(Arrays.asList(lifecycleConfigArns));
            return this;
        }

        public final List<CodeRepository.Builder> getCodeRepositories() {
            List<CodeRepository.Builder> result = CodeRepositoriesCopier.copyToBuilder(this.codeRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeRepositories(Collection<CodeRepository.BuilderImpl> codeRepositories) {
            this.codeRepositories = CodeRepositoriesCopier.copyFromBuilder(codeRepositories);
        }

        @Override
        public final Builder codeRepositories(Collection<CodeRepository> codeRepositories) {
            this.codeRepositories = CodeRepositoriesCopier.copy(codeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositories(CodeRepository ... codeRepositories) {
            this.codeRepositories(Arrays.asList(codeRepositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositories(Consumer<CodeRepository.Builder> ... codeRepositories) {
            this.codeRepositories(Stream.of(codeRepositories).map(c -> (CodeRepository)((CodeRepository.Builder)CodeRepository.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AppLifecycleManagement.Builder getAppLifecycleManagement() {
            return this.appLifecycleManagement != null ? this.appLifecycleManagement.toBuilder() : null;
        }

        public final void setAppLifecycleManagement(AppLifecycleManagement.BuilderImpl appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement != null ? appLifecycleManagement.build() : null;
        }

        @Override
        public final Builder appLifecycleManagement(AppLifecycleManagement appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement;
            return this;
        }

        public final EmrSettings.Builder getEmrSettings() {
            return this.emrSettings != null ? this.emrSettings.toBuilder() : null;
        }

        public final void setEmrSettings(EmrSettings.BuilderImpl emrSettings) {
            this.emrSettings = emrSettings != null ? emrSettings.build() : null;
        }

        @Override
        public final Builder emrSettings(EmrSettings emrSettings) {
            this.emrSettings = emrSettings;
            return this;
        }

        public final String getBuiltInLifecycleConfigArn() {
            return this.builtInLifecycleConfigArn;
        }

        public final void setBuiltInLifecycleConfigArn(String builtInLifecycleConfigArn) {
            this.builtInLifecycleConfigArn = builtInLifecycleConfigArn;
        }

        @Override
        public final Builder builtInLifecycleConfigArn(String builtInLifecycleConfigArn) {
            this.builtInLifecycleConfigArn = builtInLifecycleConfigArn;
            return this;
        }

        public JupyterLabAppSettings build() {
            return new JupyterLabAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JupyterLabAppSettings> {
        public Builder defaultResourceSpec(ResourceSpec var1);

        default public Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return this.defaultResourceSpec((ResourceSpec)((ResourceSpec.Builder)ResourceSpec.builder().applyMutation(defaultResourceSpec)).build());
        }

        public Builder customImages(Collection<CustomImage> var1);

        public Builder customImages(CustomImage ... var1);

        public Builder customImages(Consumer<CustomImage.Builder> ... var1);

        public Builder lifecycleConfigArns(Collection<String> var1);

        public Builder lifecycleConfigArns(String ... var1);

        public Builder codeRepositories(Collection<CodeRepository> var1);

        public Builder codeRepositories(CodeRepository ... var1);

        public Builder codeRepositories(Consumer<CodeRepository.Builder> ... var1);

        public Builder appLifecycleManagement(AppLifecycleManagement var1);

        default public Builder appLifecycleManagement(Consumer<AppLifecycleManagement.Builder> appLifecycleManagement) {
            return this.appLifecycleManagement((AppLifecycleManagement)((AppLifecycleManagement.Builder)AppLifecycleManagement.builder().applyMutation(appLifecycleManagement)).build());
        }

        public Builder emrSettings(EmrSettings var1);

        default public Builder emrSettings(Consumer<EmrSettings.Builder> emrSettings) {
            return this.emrSettings((EmrSettings)((EmrSettings.Builder)EmrSettings.builder().applyMutation(emrSettings)).build());
        }

        public Builder builtInLifecycleConfigArn(String var1);
    }
}

