/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelCardSummary;

public class ListModelCardsPublisher
implements SdkPublisher<ListModelCardsResponse> {
    private final SageMakerAsyncClient client;
    private final ListModelCardsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelCardsPublisher(SageMakerAsyncClient client, ListModelCardsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelCardsPublisher(SageMakerAsyncClient client, ListModelCardsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelCardsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelCardsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelCardSummary> modelCardSummaries() {
        Function<ListModelCardsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelCardSummaries() != null) {
                return response.modelCardSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelCardsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelCardsResponseFetcher
    implements AsyncPageFetcher<ListModelCardsResponse> {
        private ListModelCardsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelCardsResponse> nextPage(ListModelCardsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCardsPublisher.this.client.listModelCards(ListModelCardsPublisher.this.firstRequest);
            }
            return ListModelCardsPublisher.this.client.listModelCards((ListModelCardsRequest)((Object)ListModelCardsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

