/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobSummary;

public class ListOptimizationJobsIterable
implements SdkIterable<ListOptimizationJobsResponse> {
    private final SageMakerClient client;
    private final ListOptimizationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOptimizationJobsIterable(SageMakerClient client, ListOptimizationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOptimizationJobsResponseFetcher();
    }

    public Iterator<ListOptimizationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OptimizationJobSummary> optimizationJobSummaries() {
        Function<ListOptimizationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optimizationJobSummaries() != null) {
                return response.optimizationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOptimizationJobsResponseFetcher
    implements SyncPageFetcher<ListOptimizationJobsResponse> {
        private ListOptimizationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListOptimizationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOptimizationJobsResponse nextPage(ListOptimizationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListOptimizationJobsIterable.this.client.listOptimizationJobs(ListOptimizationJobsIterable.this.firstRequest);
            }
            return ListOptimizationJobsIterable.this.client.listOptimizationJobs((ListOptimizationJobsRequest)((Object)ListOptimizationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

