/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AppStatus;
import software.amazon.awssdk.services.sagemaker.model.AppType;
import software.amazon.awssdk.services.sagemaker.model.ResourceSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppDetails> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(AppDetails.getter(AppDetails::domainId)).setter(AppDetails.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileName").getter(AppDetails.getter(AppDetails::userProfileName)).setter(AppDetails.setter(Builder::userProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()}).build();
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceName").getter(AppDetails.getter(AppDetails::spaceName)).setter(AppDetails.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()}).build();
    private static final SdkField<String> APP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppType").getter(AppDetails.getter(AppDetails::appTypeAsString)).setter(AppDetails.setter(Builder::appType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()}).build();
    private static final SdkField<String> APP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppName").getter(AppDetails.getter(AppDetails::appName)).setter(AppDetails.setter(Builder::appName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AppDetails.getter(AppDetails::statusAsString)).setter(AppDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(AppDetails.getter(AppDetails::creationTime)).setter(AppDetails.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<ResourceSpec> RESOURCE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceSpec").getter(AppDetails.getter(AppDetails::resourceSpec)).setter(AppDetails.setter(Builder::resourceSpec)).constructor(ResourceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, USER_PROFILE_NAME_FIELD, SPACE_NAME_FIELD, APP_TYPE_FIELD, APP_NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, RESOURCE_SPEC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainId;
    private final String userProfileName;
    private final String spaceName;
    private final String appType;
    private final String appName;
    private final String status;
    private final Instant creationTime;
    private final ResourceSpec resourceSpec;

    private AppDetails(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.spaceName = builder.spaceName;
        this.appType = builder.appType;
        this.appName = builder.appName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.resourceSpec = builder.resourceSpec;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String userProfileName() {
        return this.userProfileName;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final AppType appType() {
        return AppType.fromValue(this.appType);
    }

    public final String appTypeAsString() {
        return this.appType;
    }

    public final String appName() {
        return this.appName;
    }

    public final AppStatus status() {
        return AppStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ResourceSpec resourceSpec() {
        return this.resourceSpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppDetails)) {
            return false;
        }
        AppDetails other = (AppDetails)obj;
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.userProfileName(), other.userProfileName()) && Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.appTypeAsString(), other.appTypeAsString()) && Objects.equals(this.appName(), other.appName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.resourceSpec(), other.resourceSpec());
    }

    public final String toString() {
        return ToString.builder((String)"AppDetails").add("DomainId", (Object)this.domainId()).add("UserProfileName", (Object)this.userProfileName()).add("SpaceName", (Object)this.spaceName()).add("AppType", (Object)this.appTypeAsString()).add("AppName", (Object)this.appName()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("ResourceSpec", (Object)this.resourceSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "UserProfileName": {
                return Optional.ofNullable(clazz.cast(this.userProfileName()));
            }
            case "SpaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "AppType": {
                return Optional.ofNullable(clazz.cast(this.appTypeAsString()));
            }
            case "AppName": {
                return Optional.ofNullable(clazz.cast(this.appName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ResourceSpec": {
                return Optional.ofNullable(clazz.cast(this.resourceSpec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppDetails, T> g) {
        return obj -> g.apply((AppDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainId;
        private String userProfileName;
        private String spaceName;
        private String appType;
        private String appName;
        private String status;
        private Instant creationTime;
        private ResourceSpec resourceSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(AppDetails model) {
            this.domainId(model.domainId);
            this.userProfileName(model.userProfileName);
            this.spaceName(model.spaceName);
            this.appType(model.appType);
            this.appName(model.appName);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.resourceSpec(model.resourceSpec);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getUserProfileName() {
            return this.userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getAppType() {
            return this.appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final String getAppName() {
            return this.appName;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ResourceSpec.Builder getResourceSpec() {
            return this.resourceSpec != null ? this.resourceSpec.toBuilder() : null;
        }

        public final void setResourceSpec(ResourceSpec.BuilderImpl resourceSpec) {
            this.resourceSpec = resourceSpec != null ? resourceSpec.build() : null;
        }

        @Override
        public final Builder resourceSpec(ResourceSpec resourceSpec) {
            this.resourceSpec = resourceSpec;
            return this;
        }

        public AppDetails build() {
            return new AppDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppDetails> {
        public Builder domainId(String var1);

        public Builder userProfileName(String var1);

        public Builder spaceName(String var1);

        public Builder appType(String var1);

        public Builder appType(AppType var1);

        public Builder appName(String var1);

        public Builder status(String var1);

        public Builder status(AppStatus var1);

        public Builder creationTime(Instant var1);

        public Builder resourceSpec(ResourceSpec var1);

        default public Builder resourceSpec(Consumer<ResourceSpec.Builder> resourceSpec) {
            return this.resourceSpec((ResourceSpec)((ResourceSpec.Builder)ResourceSpec.builder().applyMutation(resourceSpec)).build());
        }
    }
}

