/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLAlgorithm {
    XGBOOST("xgboost"),
    LINEAR_LEARNER("linear-learner"),
    MLP("mlp"),
    LIGHTGBM("lightgbm"),
    CATBOOST("catboost"),
    RANDOMFOREST("randomforest"),
    EXTRA_TREES("extra-trees"),
    NN_TORCH("nn-torch"),
    FASTAI("fastai"),
    CNN_QR("cnn-qr"),
    DEEPAR("deepar"),
    PROPHET("prophet"),
    NPTS("npts"),
    ARIMA("arima"),
    ETS("ets"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLAlgorithm> VALUE_MAP;
    private final String value;

    private AutoMLAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLAlgorithm> knownValues() {
        EnumSet<AutoMLAlgorithm> knownValues = EnumSet.allOf(AutoMLAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLAlgorithm.class, AutoMLAlgorithm::toString);
    }
}

