/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLComputeConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLDataSplitConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobInputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective;
import software.amazon.awssdk.services.sagemaker.model.AutoMLOutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLSecurityConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelDeployConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAutoMlJobV2Request
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateAutoMlJobV2Request> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobName").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::autoMLJobName)).setter(CreateAutoMlJobV2Request.setter(Builder::autoMLJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()}).build();
    private static final SdkField<List<AutoMLJobChannel>> AUTO_ML_JOB_INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoMLJobInputDataConfig").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::autoMLJobInputDataConfig)).setter(CreateAutoMlJobV2Request.setter(Builder::autoMLJobInputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobInputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLJobChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoMLOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::outputDataConfig)).setter(CreateAutoMlJobV2Request.setter(Builder::outputDataConfig)).constructor(AutoMLOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<AutoMLProblemTypeConfig> AUTO_ML_PROBLEM_TYPE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLProblemTypeConfig").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::autoMLProblemTypeConfig)).setter(CreateAutoMlJobV2Request.setter(Builder::autoMLProblemTypeConfig)).constructor(AutoMLProblemTypeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLProblemTypeConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::roleArn)).setter(CreateAutoMlJobV2Request.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::tags)).setter(CreateAutoMlJobV2Request.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoMLSecurityConfig> SECURITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityConfig").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::securityConfig)).setter(CreateAutoMlJobV2Request.setter(Builder::securityConfig)).constructor(AutoMLSecurityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()}).build();
    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLJobObjective").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::autoMLJobObjective)).setter(CreateAutoMlJobV2Request.setter(Builder::autoMLJobObjective)).constructor(AutoMLJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build()}).build();
    private static final SdkField<ModelDeployConfig> MODEL_DEPLOY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDeployConfig").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::modelDeployConfig)).setter(CreateAutoMlJobV2Request.setter(Builder::modelDeployConfig)).constructor(ModelDeployConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDeployConfig").build()}).build();
    private static final SdkField<AutoMLDataSplitConfig> DATA_SPLIT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSplitConfig").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::dataSplitConfig)).setter(CreateAutoMlJobV2Request.setter(Builder::dataSplitConfig)).constructor(AutoMLDataSplitConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSplitConfig").build()}).build();
    private static final SdkField<AutoMLComputeConfig> AUTO_ML_COMPUTE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLComputeConfig").getter(CreateAutoMlJobV2Request.getter(CreateAutoMlJobV2Request::autoMLComputeConfig)).setter(CreateAutoMlJobV2Request.setter(Builder::autoMLComputeConfig)).constructor(AutoMLComputeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLComputeConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD, AUTO_ML_JOB_INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, AUTO_ML_PROBLEM_TYPE_CONFIG_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, SECURITY_CONFIG_FIELD, AUTO_ML_JOB_OBJECTIVE_FIELD, MODEL_DEPLOY_CONFIG_FIELD, DATA_SPLIT_CONFIG_FIELD, AUTO_ML_COMPUTE_CONFIG_FIELD));
    private final String autoMLJobName;
    private final List<AutoMLJobChannel> autoMLJobInputDataConfig;
    private final AutoMLOutputDataConfig outputDataConfig;
    private final AutoMLProblemTypeConfig autoMLProblemTypeConfig;
    private final String roleArn;
    private final List<Tag> tags;
    private final AutoMLSecurityConfig securityConfig;
    private final AutoMLJobObjective autoMLJobObjective;
    private final ModelDeployConfig modelDeployConfig;
    private final AutoMLDataSplitConfig dataSplitConfig;
    private final AutoMLComputeConfig autoMLComputeConfig;

    private CreateAutoMlJobV2Request(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.autoMLJobInputDataConfig = builder.autoMLJobInputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.autoMLProblemTypeConfig = builder.autoMLProblemTypeConfig;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.securityConfig = builder.securityConfig;
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.modelDeployConfig = builder.modelDeployConfig;
        this.dataSplitConfig = builder.dataSplitConfig;
        this.autoMLComputeConfig = builder.autoMLComputeConfig;
    }

    public final String autoMLJobName() {
        return this.autoMLJobName;
    }

    public final boolean hasAutoMLJobInputDataConfig() {
        return this.autoMLJobInputDataConfig != null && !(this.autoMLJobInputDataConfig instanceof SdkAutoConstructList);
    }

    public final List<AutoMLJobChannel> autoMLJobInputDataConfig() {
        return this.autoMLJobInputDataConfig;
    }

    public final AutoMLOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final AutoMLProblemTypeConfig autoMLProblemTypeConfig() {
        return this.autoMLProblemTypeConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final AutoMLSecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public final AutoMLJobObjective autoMLJobObjective() {
        return this.autoMLJobObjective;
    }

    public final ModelDeployConfig modelDeployConfig() {
        return this.modelDeployConfig;
    }

    public final AutoMLDataSplitConfig dataSplitConfig() {
        return this.dataSplitConfig;
    }

    public final AutoMLComputeConfig autoMLComputeConfig() {
        return this.autoMLComputeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoMLJobInputDataConfig() ? this.autoMLJobInputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLProblemTypeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDeployConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSplitConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLComputeConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoMlJobV2Request)) {
            return false;
        }
        CreateAutoMlJobV2Request other = (CreateAutoMlJobV2Request)((Object)obj);
        return Objects.equals(this.autoMLJobName(), other.autoMLJobName()) && this.hasAutoMLJobInputDataConfig() == other.hasAutoMLJobInputDataConfig() && Objects.equals(this.autoMLJobInputDataConfig(), other.autoMLJobInputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.autoMLProblemTypeConfig(), other.autoMLProblemTypeConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.securityConfig(), other.securityConfig()) && Objects.equals(this.autoMLJobObjective(), other.autoMLJobObjective()) && Objects.equals(this.modelDeployConfig(), other.modelDeployConfig()) && Objects.equals(this.dataSplitConfig(), other.dataSplitConfig()) && Objects.equals(this.autoMLComputeConfig(), other.autoMLComputeConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAutoMlJobV2Request").add("AutoMLJobName", (Object)this.autoMLJobName()).add("AutoMLJobInputDataConfig", this.hasAutoMLJobInputDataConfig() ? this.autoMLJobInputDataConfig() : null).add("OutputDataConfig", (Object)this.outputDataConfig()).add("AutoMLProblemTypeConfig", (Object)this.autoMLProblemTypeConfig()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("SecurityConfig", (Object)this.securityConfig()).add("AutoMLJobObjective", (Object)this.autoMLJobObjective()).add("ModelDeployConfig", (Object)this.modelDeployConfig()).add("DataSplitConfig", (Object)this.dataSplitConfig()).add("AutoMLComputeConfig", (Object)this.autoMLComputeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLJobName": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobName()));
            }
            case "AutoMLJobInputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobInputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "AutoMLProblemTypeConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLProblemTypeConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SecurityConfig": {
                return Optional.ofNullable(clazz.cast(this.securityConfig()));
            }
            case "AutoMLJobObjective": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobObjective()));
            }
            case "ModelDeployConfig": {
                return Optional.ofNullable(clazz.cast(this.modelDeployConfig()));
            }
            case "DataSplitConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSplitConfig()));
            }
            case "AutoMLComputeConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLComputeConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoMlJobV2Request, T> g) {
        return obj -> g.apply((CreateAutoMlJobV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String autoMLJobName;
        private List<AutoMLJobChannel> autoMLJobInputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private AutoMLOutputDataConfig outputDataConfig;
        private AutoMLProblemTypeConfig autoMLProblemTypeConfig;
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private AutoMLSecurityConfig securityConfig;
        private AutoMLJobObjective autoMLJobObjective;
        private ModelDeployConfig modelDeployConfig;
        private AutoMLDataSplitConfig dataSplitConfig;
        private AutoMLComputeConfig autoMLComputeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoMlJobV2Request model) {
            super(model);
            this.autoMLJobName(model.autoMLJobName);
            this.autoMLJobInputDataConfig(model.autoMLJobInputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.autoMLProblemTypeConfig(model.autoMLProblemTypeConfig);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.securityConfig(model.securityConfig);
            this.autoMLJobObjective(model.autoMLJobObjective);
            this.modelDeployConfig(model.modelDeployConfig);
            this.dataSplitConfig(model.dataSplitConfig);
            this.autoMLComputeConfig(model.autoMLComputeConfig);
        }

        public final String getAutoMLJobName() {
            return this.autoMLJobName;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final List<AutoMLJobChannel.Builder> getAutoMLJobInputDataConfig() {
            List<AutoMLJobChannel.Builder> result = AutoMLJobInputDataConfigCopier.copyToBuilder(this.autoMLJobInputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoMLJobInputDataConfig(Collection<AutoMLJobChannel.BuilderImpl> autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig = AutoMLJobInputDataConfigCopier.copyFromBuilder(autoMLJobInputDataConfig);
        }

        @Override
        public final Builder autoMLJobInputDataConfig(Collection<AutoMLJobChannel> autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig = AutoMLJobInputDataConfigCopier.copy(autoMLJobInputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobInputDataConfig(AutoMLJobChannel ... autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig(Arrays.asList(autoMLJobInputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobInputDataConfig(Consumer<AutoMLJobChannel.Builder> ... autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig(Stream.of(autoMLJobInputDataConfig).map(c -> (AutoMLJobChannel)((AutoMLJobChannel.Builder)AutoMLJobChannel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoMLOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(AutoMLOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final AutoMLProblemTypeConfig.Builder getAutoMLProblemTypeConfig() {
            return this.autoMLProblemTypeConfig != null ? this.autoMLProblemTypeConfig.toBuilder() : null;
        }

        public final void setAutoMLProblemTypeConfig(AutoMLProblemTypeConfig.BuilderImpl autoMLProblemTypeConfig) {
            this.autoMLProblemTypeConfig = autoMLProblemTypeConfig != null ? autoMLProblemTypeConfig.build() : null;
        }

        @Override
        public final Builder autoMLProblemTypeConfig(AutoMLProblemTypeConfig autoMLProblemTypeConfig) {
            this.autoMLProblemTypeConfig = autoMLProblemTypeConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoMLSecurityConfig.Builder getSecurityConfig() {
            return this.securityConfig != null ? this.securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(AutoMLSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(AutoMLSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return this.autoMLJobObjective != null ? this.autoMLJobObjective.toBuilder() : null;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final ModelDeployConfig.Builder getModelDeployConfig() {
            return this.modelDeployConfig != null ? this.modelDeployConfig.toBuilder() : null;
        }

        public final void setModelDeployConfig(ModelDeployConfig.BuilderImpl modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig != null ? modelDeployConfig.build() : null;
        }

        @Override
        public final Builder modelDeployConfig(ModelDeployConfig modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig;
            return this;
        }

        public final AutoMLDataSplitConfig.Builder getDataSplitConfig() {
            return this.dataSplitConfig != null ? this.dataSplitConfig.toBuilder() : null;
        }

        public final void setDataSplitConfig(AutoMLDataSplitConfig.BuilderImpl dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig != null ? dataSplitConfig.build() : null;
        }

        @Override
        public final Builder dataSplitConfig(AutoMLDataSplitConfig dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig;
            return this;
        }

        public final AutoMLComputeConfig.Builder getAutoMLComputeConfig() {
            return this.autoMLComputeConfig != null ? this.autoMLComputeConfig.toBuilder() : null;
        }

        public final void setAutoMLComputeConfig(AutoMLComputeConfig.BuilderImpl autoMLComputeConfig) {
            this.autoMLComputeConfig = autoMLComputeConfig != null ? autoMLComputeConfig.build() : null;
        }

        @Override
        public final Builder autoMLComputeConfig(AutoMLComputeConfig autoMLComputeConfig) {
            this.autoMLComputeConfig = autoMLComputeConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoMlJobV2Request build() {
            return new CreateAutoMlJobV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAutoMlJobV2Request> {
        public Builder autoMLJobName(String var1);

        public Builder autoMLJobInputDataConfig(Collection<AutoMLJobChannel> var1);

        public Builder autoMLJobInputDataConfig(AutoMLJobChannel ... var1);

        public Builder autoMLJobInputDataConfig(Consumer<AutoMLJobChannel.Builder> ... var1);

        public Builder outputDataConfig(AutoMLOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<AutoMLOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((AutoMLOutputDataConfig)((AutoMLOutputDataConfig.Builder)AutoMLOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder autoMLProblemTypeConfig(AutoMLProblemTypeConfig var1);

        default public Builder autoMLProblemTypeConfig(Consumer<AutoMLProblemTypeConfig.Builder> autoMLProblemTypeConfig) {
            return this.autoMLProblemTypeConfig((AutoMLProblemTypeConfig)((AutoMLProblemTypeConfig.Builder)AutoMLProblemTypeConfig.builder().applyMutation(autoMLProblemTypeConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder securityConfig(AutoMLSecurityConfig var1);

        default public Builder securityConfig(Consumer<AutoMLSecurityConfig.Builder> securityConfig) {
            return this.securityConfig((AutoMLSecurityConfig)((AutoMLSecurityConfig.Builder)AutoMLSecurityConfig.builder().applyMutation(securityConfig)).build());
        }

        public Builder autoMLJobObjective(AutoMLJobObjective var1);

        default public Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return this.autoMLJobObjective((AutoMLJobObjective)((AutoMLJobObjective.Builder)AutoMLJobObjective.builder().applyMutation(autoMLJobObjective)).build());
        }

        public Builder modelDeployConfig(ModelDeployConfig var1);

        default public Builder modelDeployConfig(Consumer<ModelDeployConfig.Builder> modelDeployConfig) {
            return this.modelDeployConfig((ModelDeployConfig)((ModelDeployConfig.Builder)ModelDeployConfig.builder().applyMutation(modelDeployConfig)).build());
        }

        public Builder dataSplitConfig(AutoMLDataSplitConfig var1);

        default public Builder dataSplitConfig(Consumer<AutoMLDataSplitConfig.Builder> dataSplitConfig) {
            return this.dataSplitConfig((AutoMLDataSplitConfig)((AutoMLDataSplitConfig.Builder)AutoMLDataSplitConfig.builder().applyMutation(dataSplitConfig)).build());
        }

        public Builder autoMLComputeConfig(AutoMLComputeConfig var1);

        default public Builder autoMLComputeConfig(Consumer<AutoMLComputeConfig.Builder> autoMLComputeConfig) {
            return this.autoMLComputeConfig((AutoMLComputeConfig)((AutoMLComputeConfig.Builder)AutoMLComputeConfig.builder().applyMutation(autoMLComputeConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

