/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EndpointStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointMetadata> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(EndpointMetadata.getter(EndpointMetadata::endpointName)).setter(EndpointMetadata.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigName").getter(EndpointMetadata.getter(EndpointMetadata::endpointConfigName)).setter(EndpointMetadata.setter(Builder::endpointConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build()}).build();
    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointStatus").getter(EndpointMetadata.getter(EndpointMetadata::endpointStatusAsString)).setter(EndpointMetadata.setter(Builder::endpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(EndpointMetadata.getter(EndpointMetadata::failureReason)).setter(EndpointMetadata.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, ENDPOINT_CONFIG_NAME_FIELD, ENDPOINT_STATUS_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointName;
    private final String endpointConfigName;
    private final String endpointStatus;
    private final String failureReason;

    private EndpointMetadata(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.endpointConfigName = builder.endpointConfigName;
        this.endpointStatus = builder.endpointStatus;
        this.failureReason = builder.failureReason;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String endpointConfigName() {
        return this.endpointConfigName;
    }

    public final EndpointStatus endpointStatus() {
        return EndpointStatus.fromValue(this.endpointStatus);
    }

    public final String endpointStatusAsString() {
        return this.endpointStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointMetadata)) {
            return false;
        }
        EndpointMetadata other = (EndpointMetadata)obj;
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && Objects.equals(this.endpointStatusAsString(), other.endpointStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointMetadata").add("EndpointName", (Object)this.endpointName()).add("EndpointConfigName", (Object)this.endpointConfigName()).add("EndpointStatus", (Object)this.endpointStatusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "EndpointConfigName": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigName()));
            }
            case "EndpointStatus": {
                return Optional.ofNullable(clazz.cast(this.endpointStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointMetadata, T> g) {
        return obj -> g.apply((EndpointMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointName;
        private String endpointConfigName;
        private String endpointStatus;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointMetadata model) {
            this.endpointName(model.endpointName);
            this.endpointConfigName(model.endpointConfigName);
            this.endpointStatus(model.endpointStatus);
            this.failureReason(model.failureReason);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        public final Builder endpointStatus(EndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus == null ? null : endpointStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public EndpointMetadata build() {
            return new EndpointMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointMetadata> {
        public Builder endpointName(String var1);

        public Builder endpointConfigName(String var1);

        public Builder endpointStatus(String var1);

        public Builder endpointStatus(EndpointStatus var1);

        public Builder failureReason(String var1);
    }
}

