/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EnabledOrDisabled;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IamPolicyConstraints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IamPolicyConstraints> {
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIp").getter(IamPolicyConstraints.getter(IamPolicyConstraints::sourceIpAsString)).setter(IamPolicyConstraints.setter(Builder::sourceIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIp").build()}).build();
    private static final SdkField<String> VPC_SOURCE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcSourceIp").getter(IamPolicyConstraints.getter(IamPolicyConstraints::vpcSourceIpAsString)).setter(IamPolicyConstraints.setter(Builder::vpcSourceIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSourceIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_FIELD, VPC_SOURCE_IP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceIp;
    private final String vpcSourceIp;

    private IamPolicyConstraints(BuilderImpl builder) {
        this.sourceIp = builder.sourceIp;
        this.vpcSourceIp = builder.vpcSourceIp;
    }

    public final EnabledOrDisabled sourceIp() {
        return EnabledOrDisabled.fromValue(this.sourceIp);
    }

    public final String sourceIpAsString() {
        return this.sourceIp;
    }

    public final EnabledOrDisabled vpcSourceIp() {
        return EnabledOrDisabled.fromValue(this.vpcSourceIp);
    }

    public final String vpcSourceIpAsString() {
        return this.vpcSourceIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSourceIpAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamPolicyConstraints)) {
            return false;
        }
        IamPolicyConstraints other = (IamPolicyConstraints)obj;
        return Objects.equals(this.sourceIpAsString(), other.sourceIpAsString()) && Objects.equals(this.vpcSourceIpAsString(), other.vpcSourceIpAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IamPolicyConstraints").add("SourceIp", (Object)this.sourceIpAsString()).add("VpcSourceIp", (Object)this.vpcSourceIpAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceIp": {
                return Optional.ofNullable(clazz.cast(this.sourceIpAsString()));
            }
            case "VpcSourceIp": {
                return Optional.ofNullable(clazz.cast(this.vpcSourceIpAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IamPolicyConstraints, T> g) {
        return obj -> g.apply((IamPolicyConstraints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceIp;
        private String vpcSourceIp;

        private BuilderImpl() {
        }

        private BuilderImpl(IamPolicyConstraints model) {
            this.sourceIp(model.sourceIp);
            this.vpcSourceIp(model.vpcSourceIp);
        }

        public final String getSourceIp() {
            return this.sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        @Override
        public final Builder sourceIp(EnabledOrDisabled sourceIp) {
            this.sourceIp(sourceIp == null ? null : sourceIp.toString());
            return this;
        }

        public final String getVpcSourceIp() {
            return this.vpcSourceIp;
        }

        public final void setVpcSourceIp(String vpcSourceIp) {
            this.vpcSourceIp = vpcSourceIp;
        }

        @Override
        public final Builder vpcSourceIp(String vpcSourceIp) {
            this.vpcSourceIp = vpcSourceIp;
            return this;
        }

        @Override
        public final Builder vpcSourceIp(EnabledOrDisabled vpcSourceIp) {
            this.vpcSourceIp(vpcSourceIp == null ? null : vpcSourceIp.toString());
            return this;
        }

        public IamPolicyConstraints build() {
            return new IamPolicyConstraints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IamPolicyConstraints> {
        public Builder sourceIp(String var1);

        public Builder sourceIp(EnabledOrDisabled var1);

        public Builder vpcSourceIp(String var1);

        public Builder vpcSourceIp(EnabledOrDisabled var1);
    }
}

