/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ClusterSummary;
import software.amazon.awssdk.services.sagemaker.model.ListClustersRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClustersResponse;

public class ListClustersIterable
implements SdkIterable<ListClustersResponse> {
    private final SageMakerClient client;
    private final ListClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClustersIterable(SageMakerClient client, ListClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClustersResponseFetcher();
    }

    public Iterator<ListClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterSummary> clusterSummaries() {
        Function<ListClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterSummaries() != null) {
                return response.clusterSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClustersResponseFetcher
    implements SyncPageFetcher<ListClustersResponse> {
        private ListClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClustersResponse nextPage(ListClustersResponse previousPage) {
            if (previousPage == null) {
                return ListClustersIterable.this.client.listClusters(ListClustersIterable.this.firstRequest);
            }
            return ListClustersIterable.this.client.listClusters((ListClustersRequest)((Object)ListClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

