/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CognitoConfig;
import software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse;
import software.amazon.awssdk.services.sagemaker.model.SourceIpConfig;
import software.amazon.awssdk.services.sagemaker.model.WorkforceStatus;
import software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workforce
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workforce> {
    private static final SdkField<String> WORKFORCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkforceName").getter(Workforce.getter(Workforce::workforceName)).setter(Workforce.setter(Builder::workforceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceName").build()}).build();
    private static final SdkField<String> WORKFORCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkforceArn").getter(Workforce.getter(Workforce::workforceArn)).setter(Workforce.setter(Builder::workforceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDate").getter(Workforce.getter(Workforce::lastUpdatedDate)).setter(Workforce.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()}).build();
    private static final SdkField<SourceIpConfig> SOURCE_IP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceIpConfig").getter(Workforce.getter(Workforce::sourceIpConfig)).setter(Workforce.setter(Builder::sourceIpConfig)).constructor(SourceIpConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()}).build();
    private static final SdkField<String> SUB_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubDomain").getter(Workforce.getter(Workforce::subDomain)).setter(Workforce.setter(Builder::subDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDomain").build()}).build();
    private static final SdkField<CognitoConfig> COGNITO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CognitoConfig").getter(Workforce.getter(Workforce::cognitoConfig)).setter(Workforce.setter(Builder::cognitoConfig)).constructor(CognitoConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoConfig").build()}).build();
    private static final SdkField<OidcConfigForResponse> OIDC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OidcConfig").getter(Workforce.getter(Workforce::oidcConfig)).setter(Workforce.setter(Builder::oidcConfig)).constructor(OidcConfigForResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcConfig").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(Workforce.getter(Workforce::createDate)).setter(Workforce.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<WorkforceVpcConfigResponse> WORKFORCE_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkforceVpcConfig").getter(Workforce.getter(Workforce::workforceVpcConfig)).setter(Workforce.setter(Builder::workforceVpcConfig)).constructor(WorkforceVpcConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceVpcConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Workforce.getter(Workforce::statusAsString)).setter(Workforce.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(Workforce.getter(Workforce::failureReason)).setter(Workforce.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFORCE_NAME_FIELD, WORKFORCE_ARN_FIELD, LAST_UPDATED_DATE_FIELD, SOURCE_IP_CONFIG_FIELD, SUB_DOMAIN_FIELD, COGNITO_CONFIG_FIELD, OIDC_CONFIG_FIELD, CREATE_DATE_FIELD, WORKFORCE_VPC_CONFIG_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workforceName;
    private final String workforceArn;
    private final Instant lastUpdatedDate;
    private final SourceIpConfig sourceIpConfig;
    private final String subDomain;
    private final CognitoConfig cognitoConfig;
    private final OidcConfigForResponse oidcConfig;
    private final Instant createDate;
    private final WorkforceVpcConfigResponse workforceVpcConfig;
    private final String status;
    private final String failureReason;

    private Workforce(BuilderImpl builder) {
        this.workforceName = builder.workforceName;
        this.workforceArn = builder.workforceArn;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.sourceIpConfig = builder.sourceIpConfig;
        this.subDomain = builder.subDomain;
        this.cognitoConfig = builder.cognitoConfig;
        this.oidcConfig = builder.oidcConfig;
        this.createDate = builder.createDate;
        this.workforceVpcConfig = builder.workforceVpcConfig;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    public final String workforceName() {
        return this.workforceName;
    }

    public final String workforceArn() {
        return this.workforceArn;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final SourceIpConfig sourceIpConfig() {
        return this.sourceIpConfig;
    }

    public final String subDomain() {
        return this.subDomain;
    }

    public final CognitoConfig cognitoConfig() {
        return this.cognitoConfig;
    }

    public final OidcConfigForResponse oidcConfig() {
        return this.oidcConfig;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final WorkforceVpcConfigResponse workforceVpcConfig() {
        return this.workforceVpcConfig;
    }

    public final WorkforceStatus status() {
        return WorkforceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.subDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.oidcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workforce)) {
            return false;
        }
        Workforce other = (Workforce)obj;
        return Objects.equals(this.workforceName(), other.workforceName()) && Objects.equals(this.workforceArn(), other.workforceArn()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.sourceIpConfig(), other.sourceIpConfig()) && Objects.equals(this.subDomain(), other.subDomain()) && Objects.equals(this.cognitoConfig(), other.cognitoConfig()) && Objects.equals(this.oidcConfig(), other.oidcConfig()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.workforceVpcConfig(), other.workforceVpcConfig()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"Workforce").add("WorkforceName", (Object)this.workforceName()).add("WorkforceArn", (Object)this.workforceArn()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("SourceIpConfig", (Object)this.sourceIpConfig()).add("SubDomain", (Object)this.subDomain()).add("CognitoConfig", (Object)this.cognitoConfig()).add("OidcConfig", (Object)this.oidcConfig()).add("CreateDate", (Object)this.createDate()).add("WorkforceVpcConfig", (Object)this.workforceVpcConfig()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkforceName": {
                return Optional.ofNullable(clazz.cast(this.workforceName()));
            }
            case "WorkforceArn": {
                return Optional.ofNullable(clazz.cast(this.workforceArn()));
            }
            case "LastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "SourceIpConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceIpConfig()));
            }
            case "SubDomain": {
                return Optional.ofNullable(clazz.cast(this.subDomain()));
            }
            case "CognitoConfig": {
                return Optional.ofNullable(clazz.cast(this.cognitoConfig()));
            }
            case "OidcConfig": {
                return Optional.ofNullable(clazz.cast(this.oidcConfig()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "WorkforceVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.workforceVpcConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workforce, T> g) {
        return obj -> g.apply((Workforce)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workforceName;
        private String workforceArn;
        private Instant lastUpdatedDate;
        private SourceIpConfig sourceIpConfig;
        private String subDomain;
        private CognitoConfig cognitoConfig;
        private OidcConfigForResponse oidcConfig;
        private Instant createDate;
        private WorkforceVpcConfigResponse workforceVpcConfig;
        private String status;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(Workforce model) {
            this.workforceName(model.workforceName);
            this.workforceArn(model.workforceArn);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.sourceIpConfig(model.sourceIpConfig);
            this.subDomain(model.subDomain);
            this.cognitoConfig(model.cognitoConfig);
            this.oidcConfig(model.oidcConfig);
            this.createDate(model.createDate);
            this.workforceVpcConfig(model.workforceVpcConfig);
            this.status(model.status);
            this.failureReason(model.failureReason);
        }

        public final String getWorkforceName() {
            return this.workforceName;
        }

        public final void setWorkforceName(String workforceName) {
            this.workforceName = workforceName;
        }

        @Override
        public final Builder workforceName(String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        public final String getWorkforceArn() {
            return this.workforceArn;
        }

        public final void setWorkforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
        }

        @Override
        public final Builder workforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final SourceIpConfig.Builder getSourceIpConfig() {
            return this.sourceIpConfig != null ? this.sourceIpConfig.toBuilder() : null;
        }

        public final void setSourceIpConfig(SourceIpConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final String getSubDomain() {
            return this.subDomain;
        }

        public final void setSubDomain(String subDomain) {
            this.subDomain = subDomain;
        }

        @Override
        public final Builder subDomain(String subDomain) {
            this.subDomain = subDomain;
            return this;
        }

        public final CognitoConfig.Builder getCognitoConfig() {
            return this.cognitoConfig != null ? this.cognitoConfig.toBuilder() : null;
        }

        public final void setCognitoConfig(CognitoConfig.BuilderImpl cognitoConfig) {
            this.cognitoConfig = cognitoConfig != null ? cognitoConfig.build() : null;
        }

        @Override
        public final Builder cognitoConfig(CognitoConfig cognitoConfig) {
            this.cognitoConfig = cognitoConfig;
            return this;
        }

        public final OidcConfigForResponse.Builder getOidcConfig() {
            return this.oidcConfig != null ? this.oidcConfig.toBuilder() : null;
        }

        public final void setOidcConfig(OidcConfigForResponse.BuilderImpl oidcConfig) {
            this.oidcConfig = oidcConfig != null ? oidcConfig.build() : null;
        }

        @Override
        public final Builder oidcConfig(OidcConfigForResponse oidcConfig) {
            this.oidcConfig = oidcConfig;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final WorkforceVpcConfigResponse.Builder getWorkforceVpcConfig() {
            return this.workforceVpcConfig != null ? this.workforceVpcConfig.toBuilder() : null;
        }

        public final void setWorkforceVpcConfig(WorkforceVpcConfigResponse.BuilderImpl workforceVpcConfig) {
            this.workforceVpcConfig = workforceVpcConfig != null ? workforceVpcConfig.build() : null;
        }

        @Override
        public final Builder workforceVpcConfig(WorkforceVpcConfigResponse workforceVpcConfig) {
            this.workforceVpcConfig = workforceVpcConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkforceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public Workforce build() {
            return new Workforce(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workforce> {
        public Builder workforceName(String var1);

        public Builder workforceArn(String var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder sourceIpConfig(SourceIpConfig var1);

        default public Builder sourceIpConfig(Consumer<SourceIpConfig.Builder> sourceIpConfig) {
            return this.sourceIpConfig((SourceIpConfig)((SourceIpConfig.Builder)SourceIpConfig.builder().applyMutation(sourceIpConfig)).build());
        }

        public Builder subDomain(String var1);

        public Builder cognitoConfig(CognitoConfig var1);

        default public Builder cognitoConfig(Consumer<CognitoConfig.Builder> cognitoConfig) {
            return this.cognitoConfig((CognitoConfig)((CognitoConfig.Builder)CognitoConfig.builder().applyMutation(cognitoConfig)).build());
        }

        public Builder oidcConfig(OidcConfigForResponse var1);

        default public Builder oidcConfig(Consumer<OidcConfigForResponse.Builder> oidcConfig) {
            return this.oidcConfig((OidcConfigForResponse)((OidcConfigForResponse.Builder)OidcConfigForResponse.builder().applyMutation(oidcConfig)).build());
        }

        public Builder createDate(Instant var1);

        public Builder workforceVpcConfig(WorkforceVpcConfigResponse var1);

        default public Builder workforceVpcConfig(Consumer<WorkforceVpcConfigResponse.Builder> workforceVpcConfig) {
            return this.workforceVpcConfig((WorkforceVpcConfigResponse)((WorkforceVpcConfigResponse.Builder)WorkforceVpcConfigResponse.builder().applyMutation(workforceVpcConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(WorkforceStatus var1);

        public Builder failureReason(String var1);
    }
}

