/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ProfilerConfigForUpdate;
import software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration;
import software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfigurationsCopier;
import software.amazon.awssdk.services.sagemaker.model.RemoteDebugConfigForUpdate;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfigForUpdate;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrainingJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateTrainingJobRequest> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobName").getter(UpdateTrainingJobRequest.getter(UpdateTrainingJobRequest::trainingJobName)).setter(UpdateTrainingJobRequest.setter(Builder::trainingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()}).build();
    private static final SdkField<ProfilerConfigForUpdate> PROFILER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProfilerConfig").getter(UpdateTrainingJobRequest.getter(UpdateTrainingJobRequest::profilerConfig)).setter(UpdateTrainingJobRequest.setter(Builder::profilerConfig)).constructor(ProfilerConfigForUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerConfig").build()}).build();
    private static final SdkField<List<ProfilerRuleConfiguration>> PROFILER_RULE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfilerRuleConfigurations").getter(UpdateTrainingJobRequest.getter(UpdateTrainingJobRequest::profilerRuleConfigurations)).setter(UpdateTrainingJobRequest.setter(Builder::profilerRuleConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerRuleConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfilerRuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResourceConfigForUpdate> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceConfig").getter(UpdateTrainingJobRequest.getter(UpdateTrainingJobRequest::resourceConfig)).setter(UpdateTrainingJobRequest.setter(Builder::resourceConfig)).constructor(ResourceConfigForUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()}).build();
    private static final SdkField<RemoteDebugConfigForUpdate> REMOTE_DEBUG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteDebugConfig").getter(UpdateTrainingJobRequest.getter(UpdateTrainingJobRequest::remoteDebugConfig)).setter(UpdateTrainingJobRequest.setter(Builder::remoteDebugConfig)).constructor(RemoteDebugConfigForUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDebugConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD, PROFILER_CONFIG_FIELD, PROFILER_RULE_CONFIGURATIONS_FIELD, RESOURCE_CONFIG_FIELD, REMOTE_DEBUG_CONFIG_FIELD));
    private final String trainingJobName;
    private final ProfilerConfigForUpdate profilerConfig;
    private final List<ProfilerRuleConfiguration> profilerRuleConfigurations;
    private final ResourceConfigForUpdate resourceConfig;
    private final RemoteDebugConfigForUpdate remoteDebugConfig;

    private UpdateTrainingJobRequest(BuilderImpl builder) {
        super(builder);
        this.trainingJobName = builder.trainingJobName;
        this.profilerConfig = builder.profilerConfig;
        this.profilerRuleConfigurations = builder.profilerRuleConfigurations;
        this.resourceConfig = builder.resourceConfig;
        this.remoteDebugConfig = builder.remoteDebugConfig;
    }

    public final String trainingJobName() {
        return this.trainingJobName;
    }

    public final ProfilerConfigForUpdate profilerConfig() {
        return this.profilerConfig;
    }

    public final boolean hasProfilerRuleConfigurations() {
        return this.profilerRuleConfigurations != null && !(this.profilerRuleConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ProfilerRuleConfiguration> profilerRuleConfigurations() {
        return this.profilerRuleConfigurations;
    }

    public final ResourceConfigForUpdate resourceConfig() {
        return this.resourceConfig;
    }

    public final RemoteDebugConfigForUpdate remoteDebugConfig() {
        return this.remoteDebugConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfilerRuleConfigurations() ? this.profilerRuleConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDebugConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrainingJobRequest)) {
            return false;
        }
        UpdateTrainingJobRequest other = (UpdateTrainingJobRequest)((Object)obj);
        return Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.profilerConfig(), other.profilerConfig()) && this.hasProfilerRuleConfigurations() == other.hasProfilerRuleConfigurations() && Objects.equals(this.profilerRuleConfigurations(), other.profilerRuleConfigurations()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.remoteDebugConfig(), other.remoteDebugConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrainingJobRequest").add("TrainingJobName", (Object)this.trainingJobName()).add("ProfilerConfig", (Object)this.profilerConfig()).add("ProfilerRuleConfigurations", this.hasProfilerRuleConfigurations() ? this.profilerRuleConfigurations() : null).add("ResourceConfig", (Object)this.resourceConfig()).add("RemoteDebugConfig", (Object)this.remoteDebugConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "ProfilerConfig": {
                return Optional.ofNullable(clazz.cast(this.profilerConfig()));
            }
            case "ProfilerRuleConfigurations": {
                return Optional.ofNullable(clazz.cast(this.profilerRuleConfigurations()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "RemoteDebugConfig": {
                return Optional.ofNullable(clazz.cast(this.remoteDebugConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrainingJobRequest, T> g) {
        return obj -> g.apply((UpdateTrainingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String trainingJobName;
        private ProfilerConfigForUpdate profilerConfig;
        private List<ProfilerRuleConfiguration> profilerRuleConfigurations = DefaultSdkAutoConstructList.getInstance();
        private ResourceConfigForUpdate resourceConfig;
        private RemoteDebugConfigForUpdate remoteDebugConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrainingJobRequest model) {
            super(model);
            this.trainingJobName(model.trainingJobName);
            this.profilerConfig(model.profilerConfig);
            this.profilerRuleConfigurations(model.profilerRuleConfigurations);
            this.resourceConfig(model.resourceConfig);
            this.remoteDebugConfig(model.remoteDebugConfig);
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final ProfilerConfigForUpdate.Builder getProfilerConfig() {
            return this.profilerConfig != null ? this.profilerConfig.toBuilder() : null;
        }

        public final void setProfilerConfig(ProfilerConfigForUpdate.BuilderImpl profilerConfig) {
            this.profilerConfig = profilerConfig != null ? profilerConfig.build() : null;
        }

        @Override
        public final Builder profilerConfig(ProfilerConfigForUpdate profilerConfig) {
            this.profilerConfig = profilerConfig;
            return this;
        }

        public final List<ProfilerRuleConfiguration.Builder> getProfilerRuleConfigurations() {
            List<ProfilerRuleConfiguration.Builder> result = ProfilerRuleConfigurationsCopier.copyToBuilder(this.profilerRuleConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfilerRuleConfigurations(Collection<ProfilerRuleConfiguration.BuilderImpl> profilerRuleConfigurations) {
            this.profilerRuleConfigurations = ProfilerRuleConfigurationsCopier.copyFromBuilder(profilerRuleConfigurations);
        }

        @Override
        public final Builder profilerRuleConfigurations(Collection<ProfilerRuleConfiguration> profilerRuleConfigurations) {
            this.profilerRuleConfigurations = ProfilerRuleConfigurationsCopier.copy(profilerRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleConfigurations(ProfilerRuleConfiguration ... profilerRuleConfigurations) {
            this.profilerRuleConfigurations(Arrays.asList(profilerRuleConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleConfigurations(Consumer<ProfilerRuleConfiguration.Builder> ... profilerRuleConfigurations) {
            this.profilerRuleConfigurations(Stream.of(profilerRuleConfigurations).map(c -> (ProfilerRuleConfiguration)((ProfilerRuleConfiguration.Builder)ProfilerRuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResourceConfigForUpdate.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfigForUpdate.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfigForUpdate resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final RemoteDebugConfigForUpdate.Builder getRemoteDebugConfig() {
            return this.remoteDebugConfig != null ? this.remoteDebugConfig.toBuilder() : null;
        }

        public final void setRemoteDebugConfig(RemoteDebugConfigForUpdate.BuilderImpl remoteDebugConfig) {
            this.remoteDebugConfig = remoteDebugConfig != null ? remoteDebugConfig.build() : null;
        }

        @Override
        public final Builder remoteDebugConfig(RemoteDebugConfigForUpdate remoteDebugConfig) {
            this.remoteDebugConfig = remoteDebugConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrainingJobRequest build() {
            return new UpdateTrainingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrainingJobRequest> {
        public Builder trainingJobName(String var1);

        public Builder profilerConfig(ProfilerConfigForUpdate var1);

        default public Builder profilerConfig(Consumer<ProfilerConfigForUpdate.Builder> profilerConfig) {
            return this.profilerConfig((ProfilerConfigForUpdate)((ProfilerConfigForUpdate.Builder)ProfilerConfigForUpdate.builder().applyMutation(profilerConfig)).build());
        }

        public Builder profilerRuleConfigurations(Collection<ProfilerRuleConfiguration> var1);

        public Builder profilerRuleConfigurations(ProfilerRuleConfiguration ... var1);

        public Builder profilerRuleConfigurations(Consumer<ProfilerRuleConfiguration.Builder> ... var1);

        public Builder resourceConfig(ResourceConfigForUpdate var1);

        default public Builder resourceConfig(Consumer<ResourceConfigForUpdate.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfigForUpdate)((ResourceConfigForUpdate.Builder)ResourceConfigForUpdate.builder().applyMutation(resourceConfig)).build());
        }

        public Builder remoteDebugConfig(RemoteDebugConfigForUpdate var1);

        default public Builder remoteDebugConfig(Consumer<RemoteDebugConfigForUpdate.Builder> remoteDebugConfig) {
            return this.remoteDebugConfig((RemoteDebugConfigForUpdate)((RemoteDebugConfigForUpdate.Builder)RemoteDebugConfigForUpdate.builder().applyMutation(remoteDebugConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

