/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SharingType {
    PRIVATE("Private"),
    SHARED("Shared"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SharingType> VALUE_MAP;
    private final String value;

    private SharingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SharingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SharingType> knownValues() {
        EnumSet<SharingType> knownValues = EnumSet.allOf(SharingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SharingType.class, SharingType::toString);
    }
}

