/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RoutingStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariantRoutingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductionVariantRoutingConfig> {
    private static final SdkField<String> ROUTING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingStrategy").getter(ProductionVariantRoutingConfig.getter(ProductionVariantRoutingConfig::routingStrategyAsString)).setter(ProductionVariantRoutingConfig.setter(Builder::routingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String routingStrategy;

    private ProductionVariantRoutingConfig(BuilderImpl builder) {
        this.routingStrategy = builder.routingStrategy;
    }

    public final RoutingStrategy routingStrategy() {
        return RoutingStrategy.fromValue(this.routingStrategy);
    }

    public final String routingStrategyAsString() {
        return this.routingStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routingStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantRoutingConfig)) {
            return false;
        }
        ProductionVariantRoutingConfig other = (ProductionVariantRoutingConfig)obj;
        return Objects.equals(this.routingStrategyAsString(), other.routingStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProductionVariantRoutingConfig").add("RoutingStrategy", (Object)this.routingStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingStrategy": {
                return Optional.ofNullable(clazz.cast(this.routingStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantRoutingConfig, T> g) {
        return obj -> g.apply((ProductionVariantRoutingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String routingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantRoutingConfig model) {
            this.routingStrategy(model.routingStrategy);
        }

        public final String getRoutingStrategy() {
            return this.routingStrategy;
        }

        public final void setRoutingStrategy(String routingStrategy) {
            this.routingStrategy = routingStrategy;
        }

        @Override
        public final Builder routingStrategy(String routingStrategy) {
            this.routingStrategy = routingStrategy;
            return this;
        }

        @Override
        public final Builder routingStrategy(RoutingStrategy routingStrategy) {
            this.routingStrategy(routingStrategy == null ? null : routingStrategy.toString());
            return this;
        }

        public ProductionVariantRoutingConfig build() {
            return new ProductionVariantRoutingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductionVariantRoutingConfig> {
        public Builder routingStrategy(String var1);

        public Builder routingStrategy(RoutingStrategy var1);
    }
}

