/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FillingType {
    FRONTFILL("frontfill"),
    MIDDLEFILL("middlefill"),
    BACKFILL("backfill"),
    FUTUREFILL("futurefill"),
    FRONTFILL_VALUE("frontfill_value"),
    MIDDLEFILL_VALUE("middlefill_value"),
    BACKFILL_VALUE("backfill_value"),
    FUTUREFILL_VALUE("futurefill_value"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FillingType> VALUE_MAP;
    private final String value;

    private FillingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FillingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FillingType> knownValues() {
        EnumSet<FillingType> knownValues = EnumSet.allOf(FillingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FillingType.class, FillingType::toString);
    }
}

