/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MemberDefinition;
import software.amazon.awssdk.services.sagemaker.model.MemberDefinitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.NotificationConfiguration;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkteamRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateWorkteamRequest> {
    private static final SdkField<String> WORKTEAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkteamName").getter(CreateWorkteamRequest.getter(CreateWorkteamRequest::workteamName)).setter(CreateWorkteamRequest.setter(Builder::workteamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamName").build()}).build();
    private static final SdkField<String> WORKFORCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkforceName").getter(CreateWorkteamRequest.getter(CreateWorkteamRequest::workforceName)).setter(CreateWorkteamRequest.setter(Builder::workforceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceName").build()}).build();
    private static final SdkField<List<MemberDefinition>> MEMBER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberDefinitions").getter(CreateWorkteamRequest.getter(CreateWorkteamRequest::memberDefinitions)).setter(CreateWorkteamRequest.setter(Builder::memberDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateWorkteamRequest.getter(CreateWorkteamRequest::description)).setter(CreateWorkteamRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfiguration").getter(CreateWorkteamRequest.getter(CreateWorkteamRequest::notificationConfiguration)).setter(CreateWorkteamRequest.setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateWorkteamRequest.getter(CreateWorkteamRequest::tags)).setter(CreateWorkteamRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_NAME_FIELD, WORKFORCE_NAME_FIELD, MEMBER_DEFINITIONS_FIELD, DESCRIPTION_FIELD, NOTIFICATION_CONFIGURATION_FIELD, TAGS_FIELD));
    private final String workteamName;
    private final String workforceName;
    private final List<MemberDefinition> memberDefinitions;
    private final String description;
    private final NotificationConfiguration notificationConfiguration;
    private final List<Tag> tags;

    private CreateWorkteamRequest(BuilderImpl builder) {
        super(builder);
        this.workteamName = builder.workteamName;
        this.workforceName = builder.workforceName;
        this.memberDefinitions = builder.memberDefinitions;
        this.description = builder.description;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.tags = builder.tags;
    }

    public final String workteamName() {
        return this.workteamName;
    }

    public final String workforceName() {
        return this.workforceName;
    }

    public final boolean hasMemberDefinitions() {
        return this.memberDefinitions != null && !(this.memberDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MemberDefinition> memberDefinitions() {
        return this.memberDefinitions;
    }

    public final String description() {
        return this.description;
    }

    public final NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workteamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberDefinitions() ? this.memberDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkteamRequest)) {
            return false;
        }
        CreateWorkteamRequest other = (CreateWorkteamRequest)((Object)obj);
        return Objects.equals(this.workteamName(), other.workteamName()) && Objects.equals(this.workforceName(), other.workforceName()) && this.hasMemberDefinitions() == other.hasMemberDefinitions() && Objects.equals(this.memberDefinitions(), other.memberDefinitions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkteamRequest").add("WorkteamName", (Object)this.workteamName()).add("WorkforceName", (Object)this.workforceName()).add("MemberDefinitions", this.hasMemberDefinitions() ? this.memberDefinitions() : null).add("Description", (Object)this.description()).add("NotificationConfiguration", (Object)this.notificationConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkteamName": {
                return Optional.ofNullable(clazz.cast(this.workteamName()));
            }
            case "WorkforceName": {
                return Optional.ofNullable(clazz.cast(this.workforceName()));
            }
            case "MemberDefinitions": {
                return Optional.ofNullable(clazz.cast(this.memberDefinitions()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "NotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkteamRequest, T> g) {
        return obj -> g.apply((CreateWorkteamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String workteamName;
        private String workforceName;
        private List<MemberDefinition> memberDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private NotificationConfiguration notificationConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkteamRequest model) {
            super(model);
            this.workteamName(model.workteamName);
            this.workforceName(model.workforceName);
            this.memberDefinitions(model.memberDefinitions);
            this.description(model.description);
            this.notificationConfiguration(model.notificationConfiguration);
            this.tags(model.tags);
        }

        public final String getWorkteamName() {
            return this.workteamName;
        }

        public final void setWorkteamName(String workteamName) {
            this.workteamName = workteamName;
        }

        @Override
        public final Builder workteamName(String workteamName) {
            this.workteamName = workteamName;
            return this;
        }

        public final String getWorkforceName() {
            return this.workforceName;
        }

        public final void setWorkforceName(String workforceName) {
            this.workforceName = workforceName;
        }

        @Override
        public final Builder workforceName(String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        public final List<MemberDefinition.Builder> getMemberDefinitions() {
            List<MemberDefinition.Builder> result = MemberDefinitionsCopier.copyToBuilder(this.memberDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberDefinitions(Collection<MemberDefinition.BuilderImpl> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copyFromBuilder(memberDefinitions);
        }

        @Override
        public final Builder memberDefinitions(Collection<MemberDefinition> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copy(memberDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(MemberDefinition ... memberDefinitions) {
            this.memberDefinitions(Arrays.asList(memberDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(Consumer<MemberDefinition.Builder> ... memberDefinitions) {
            this.memberDefinitions(Stream.of(memberDefinitions).map(c -> (MemberDefinition)((MemberDefinition.Builder)MemberDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkteamRequest build() {
            return new CreateWorkteamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkteamRequest> {
        public Builder workteamName(String var1);

        public Builder workforceName(String var1);

        public Builder memberDefinitions(Collection<MemberDefinition> var1);

        public Builder memberDefinitions(MemberDefinition ... var1);

        public Builder memberDefinitions(Consumer<MemberDefinition.Builder> ... var1);

        public Builder description(String var1);

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().applyMutation(notificationConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

