/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInferenceComponentRuntimeConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateInferenceComponentRuntimeConfigRequest.Builder, UpdateInferenceComponentRuntimeConfigRequest> {
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceComponentName")
            .getter(getter(UpdateInferenceComponentRuntimeConfigRequest::inferenceComponentName))
            .setter(setter(Builder::inferenceComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build())
            .build();

    private static final SdkField<InferenceComponentRuntimeConfig> DESIRED_RUNTIME_CONFIG_FIELD = SdkField
            .<InferenceComponentRuntimeConfig> builder(MarshallingType.SDK_POJO).memberName("DesiredRuntimeConfig")
            .getter(getter(UpdateInferenceComponentRuntimeConfigRequest::desiredRuntimeConfig))
            .setter(setter(Builder::desiredRuntimeConfig)).constructor(InferenceComponentRuntimeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredRuntimeConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFERENCE_COMPONENT_NAME_FIELD, DESIRED_RUNTIME_CONFIG_FIELD));

    private final String inferenceComponentName;

    private final InferenceComponentRuntimeConfig desiredRuntimeConfig;

    private UpdateInferenceComponentRuntimeConfigRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceComponentName = builder.inferenceComponentName;
        this.desiredRuntimeConfig = builder.desiredRuntimeConfig;
    }

    /**
     * <p>
     * The name of the inference component to update.
     * </p>
     * 
     * @return The name of the inference component to update.
     */
    public final String inferenceComponentName() {
        return inferenceComponentName;
    }

    /**
     * <p>
     * Runtime settings for a model that is deployed with an inference component.
     * </p>
     * 
     * @return Runtime settings for a model that is deployed with an inference component.
     */
    public final InferenceComponentRuntimeConfig desiredRuntimeConfig() {
        return desiredRuntimeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(desiredRuntimeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInferenceComponentRuntimeConfigRequest)) {
            return false;
        }
        UpdateInferenceComponentRuntimeConfigRequest other = (UpdateInferenceComponentRuntimeConfigRequest) obj;
        return Objects.equals(inferenceComponentName(), other.inferenceComponentName())
                && Objects.equals(desiredRuntimeConfig(), other.desiredRuntimeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInferenceComponentRuntimeConfigRequest")
                .add("InferenceComponentName", inferenceComponentName()).add("DesiredRuntimeConfig", desiredRuntimeConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceComponentName":
            return Optional.ofNullable(clazz.cast(inferenceComponentName()));
        case "DesiredRuntimeConfig":
            return Optional.ofNullable(clazz.cast(desiredRuntimeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInferenceComponentRuntimeConfigRequest, T> g) {
        return obj -> g.apply((UpdateInferenceComponentRuntimeConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInferenceComponentRuntimeConfigRequest> {
        /**
         * <p>
         * The name of the inference component to update.
         * </p>
         * 
         * @param inferenceComponentName
         *        The name of the inference component to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceComponentName(String inferenceComponentName);

        /**
         * <p>
         * Runtime settings for a model that is deployed with an inference component.
         * </p>
         * 
         * @param desiredRuntimeConfig
         *        Runtime settings for a model that is deployed with an inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredRuntimeConfig(InferenceComponentRuntimeConfig desiredRuntimeConfig);

        /**
         * <p>
         * Runtime settings for a model that is deployed with an inference component.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceComponentRuntimeConfig.Builder}
         * avoiding the need to create one manually via {@link InferenceComponentRuntimeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentRuntimeConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #desiredRuntimeConfig(InferenceComponentRuntimeConfig)}.
         * 
         * @param desiredRuntimeConfig
         *        a consumer that will call methods on {@link InferenceComponentRuntimeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #desiredRuntimeConfig(InferenceComponentRuntimeConfig)
         */
        default Builder desiredRuntimeConfig(Consumer<InferenceComponentRuntimeConfig.Builder> desiredRuntimeConfig) {
            return desiredRuntimeConfig(InferenceComponentRuntimeConfig.builder().applyMutation(desiredRuntimeConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String inferenceComponentName;

        private InferenceComponentRuntimeConfig desiredRuntimeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInferenceComponentRuntimeConfigRequest model) {
            super(model);
            inferenceComponentName(model.inferenceComponentName);
            desiredRuntimeConfig(model.desiredRuntimeConfig);
        }

        public final String getInferenceComponentName() {
            return inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final InferenceComponentRuntimeConfig.Builder getDesiredRuntimeConfig() {
            return desiredRuntimeConfig != null ? desiredRuntimeConfig.toBuilder() : null;
        }

        public final void setDesiredRuntimeConfig(InferenceComponentRuntimeConfig.BuilderImpl desiredRuntimeConfig) {
            this.desiredRuntimeConfig = desiredRuntimeConfig != null ? desiredRuntimeConfig.build() : null;
        }

        @Override
        public final Builder desiredRuntimeConfig(InferenceComponentRuntimeConfig desiredRuntimeConfig) {
            this.desiredRuntimeConfig = desiredRuntimeConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInferenceComponentRuntimeConfigRequest build() {
            return new UpdateInferenceComponentRuntimeConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
