/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metrics of recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationMetrics.Builder, RecommendationMetrics> {
    private static final SdkField<Float> COST_PER_HOUR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("CostPerHour").getter(getter(RecommendationMetrics::costPerHour)).setter(setter(Builder::costPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostPerHour").build()).build();

    private static final SdkField<Float> COST_PER_INFERENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("CostPerInference").getter(getter(RecommendationMetrics::costPerInference))
            .setter(setter(Builder::costPerInference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostPerInference").build()).build();

    private static final SdkField<Integer> MAX_INVOCATIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInvocations").getter(getter(RecommendationMetrics::maxInvocations))
            .setter(setter(Builder::maxInvocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInvocations").build()).build();

    private static final SdkField<Integer> MODEL_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelLatency").getter(getter(RecommendationMetrics::modelLatency)).setter(setter(Builder::modelLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLatency").build()).build();

    private static final SdkField<Float> CPU_UTILIZATION_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("CpuUtilization").getter(getter(RecommendationMetrics::cpuUtilization))
            .setter(setter(Builder::cpuUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuUtilization").build()).build();

    private static final SdkField<Float> MEMORY_UTILIZATION_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MemoryUtilization").getter(getter(RecommendationMetrics::memoryUtilization))
            .setter(setter(Builder::memoryUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryUtilization").build()).build();

    private static final SdkField<Integer> MODEL_SETUP_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelSetupTime").getter(getter(RecommendationMetrics::modelSetupTime))
            .setter(setter(Builder::modelSetupTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSetupTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_PER_HOUR_FIELD,
            COST_PER_INFERENCE_FIELD, MAX_INVOCATIONS_FIELD, MODEL_LATENCY_FIELD, CPU_UTILIZATION_FIELD,
            MEMORY_UTILIZATION_FIELD, MODEL_SETUP_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float costPerHour;

    private final Float costPerInference;

    private final Integer maxInvocations;

    private final Integer modelLatency;

    private final Float cpuUtilization;

    private final Float memoryUtilization;

    private final Integer modelSetupTime;

    private RecommendationMetrics(BuilderImpl builder) {
        this.costPerHour = builder.costPerHour;
        this.costPerInference = builder.costPerInference;
        this.maxInvocations = builder.maxInvocations;
        this.modelLatency = builder.modelLatency;
        this.cpuUtilization = builder.cpuUtilization;
        this.memoryUtilization = builder.memoryUtilization;
        this.modelSetupTime = builder.modelSetupTime;
    }

    /**
     * <p>
     * Defines the cost per hour for the instance.
     * </p>
     * 
     * @return Defines the cost per hour for the instance.
     */
    public final Float costPerHour() {
        return costPerHour;
    }

    /**
     * <p>
     * Defines the cost per inference for the instance .
     * </p>
     * 
     * @return Defines the cost per inference for the instance .
     */
    public final Float costPerInference() {
        return costPerInference;
    }

    /**
     * <p>
     * The expected maximum number of requests per minute for the instance.
     * </p>
     * 
     * @return The expected maximum number of requests per minute for the instance.
     */
    public final Integer maxInvocations() {
        return maxInvocations;
    }

    /**
     * <p>
     * The expected model latency at maximum invocation per minute for the instance.
     * </p>
     * 
     * @return The expected model latency at maximum invocation per minute for the instance.
     */
    public final Integer modelLatency() {
        return modelLatency;
    }

    /**
     * <p>
     * The expected CPU utilization at maximum invocations per minute for the instance.
     * </p>
     * <p>
     * <code>NaN</code> indicates that the value is not available.
     * </p>
     * 
     * @return The expected CPU utilization at maximum invocations per minute for the instance.</p>
     *         <p>
     *         <code>NaN</code> indicates that the value is not available.
     */
    public final Float cpuUtilization() {
        return cpuUtilization;
    }

    /**
     * <p>
     * The expected memory utilization at maximum invocations per minute for the instance.
     * </p>
     * <p>
     * <code>NaN</code> indicates that the value is not available.
     * </p>
     * 
     * @return The expected memory utilization at maximum invocations per minute for the instance.</p>
     *         <p>
     *         <code>NaN</code> indicates that the value is not available.
     */
    public final Float memoryUtilization() {
        return memoryUtilization;
    }

    /**
     * <p>
     * The time it takes to launch new compute resources for a serverless endpoint. The time can vary depending on the
     * model size, how long it takes to download the model, and the start-up time of the container.
     * </p>
     * <p>
     * <code>NaN</code> indicates that the value is not available.
     * </p>
     * 
     * @return The time it takes to launch new compute resources for a serverless endpoint. The time can vary depending
     *         on the model size, how long it takes to download the model, and the start-up time of the container.</p>
     *         <p>
     *         <code>NaN</code> indicates that the value is not available.
     */
    public final Integer modelSetupTime() {
        return modelSetupTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(costPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(costPerInference());
        hashCode = 31 * hashCode + Objects.hashCode(maxInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(modelLatency());
        hashCode = 31 * hashCode + Objects.hashCode(cpuUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(memoryUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(modelSetupTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationMetrics)) {
            return false;
        }
        RecommendationMetrics other = (RecommendationMetrics) obj;
        return Objects.equals(costPerHour(), other.costPerHour()) && Objects.equals(costPerInference(), other.costPerInference())
                && Objects.equals(maxInvocations(), other.maxInvocations())
                && Objects.equals(modelLatency(), other.modelLatency())
                && Objects.equals(cpuUtilization(), other.cpuUtilization())
                && Objects.equals(memoryUtilization(), other.memoryUtilization())
                && Objects.equals(modelSetupTime(), other.modelSetupTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationMetrics").add("CostPerHour", costPerHour())
                .add("CostPerInference", costPerInference()).add("MaxInvocations", maxInvocations())
                .add("ModelLatency", modelLatency()).add("CpuUtilization", cpuUtilization())
                .add("MemoryUtilization", memoryUtilization()).add("ModelSetupTime", modelSetupTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostPerHour":
            return Optional.ofNullable(clazz.cast(costPerHour()));
        case "CostPerInference":
            return Optional.ofNullable(clazz.cast(costPerInference()));
        case "MaxInvocations":
            return Optional.ofNullable(clazz.cast(maxInvocations()));
        case "ModelLatency":
            return Optional.ofNullable(clazz.cast(modelLatency()));
        case "CpuUtilization":
            return Optional.ofNullable(clazz.cast(cpuUtilization()));
        case "MemoryUtilization":
            return Optional.ofNullable(clazz.cast(memoryUtilization()));
        case "ModelSetupTime":
            return Optional.ofNullable(clazz.cast(modelSetupTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationMetrics, T> g) {
        return obj -> g.apply((RecommendationMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationMetrics> {
        /**
         * <p>
         * Defines the cost per hour for the instance.
         * </p>
         * 
         * @param costPerHour
         *        Defines the cost per hour for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costPerHour(Float costPerHour);

        /**
         * <p>
         * Defines the cost per inference for the instance .
         * </p>
         * 
         * @param costPerInference
         *        Defines the cost per inference for the instance .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costPerInference(Float costPerInference);

        /**
         * <p>
         * The expected maximum number of requests per minute for the instance.
         * </p>
         * 
         * @param maxInvocations
         *        The expected maximum number of requests per minute for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInvocations(Integer maxInvocations);

        /**
         * <p>
         * The expected model latency at maximum invocation per minute for the instance.
         * </p>
         * 
         * @param modelLatency
         *        The expected model latency at maximum invocation per minute for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelLatency(Integer modelLatency);

        /**
         * <p>
         * The expected CPU utilization at maximum invocations per minute for the instance.
         * </p>
         * <p>
         * <code>NaN</code> indicates that the value is not available.
         * </p>
         * 
         * @param cpuUtilization
         *        The expected CPU utilization at maximum invocations per minute for the instance.</p>
         *        <p>
         *        <code>NaN</code> indicates that the value is not available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuUtilization(Float cpuUtilization);

        /**
         * <p>
         * The expected memory utilization at maximum invocations per minute for the instance.
         * </p>
         * <p>
         * <code>NaN</code> indicates that the value is not available.
         * </p>
         * 
         * @param memoryUtilization
         *        The expected memory utilization at maximum invocations per minute for the instance.</p>
         *        <p>
         *        <code>NaN</code> indicates that the value is not available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryUtilization(Float memoryUtilization);

        /**
         * <p>
         * The time it takes to launch new compute resources for a serverless endpoint. The time can vary depending on
         * the model size, how long it takes to download the model, and the start-up time of the container.
         * </p>
         * <p>
         * <code>NaN</code> indicates that the value is not available.
         * </p>
         * 
         * @param modelSetupTime
         *        The time it takes to launch new compute resources for a serverless endpoint. The time can vary
         *        depending on the model size, how long it takes to download the model, and the start-up time of the
         *        container.</p>
         *        <p>
         *        <code>NaN</code> indicates that the value is not available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSetupTime(Integer modelSetupTime);
    }

    static final class BuilderImpl implements Builder {
        private Float costPerHour;

        private Float costPerInference;

        private Integer maxInvocations;

        private Integer modelLatency;

        private Float cpuUtilization;

        private Float memoryUtilization;

        private Integer modelSetupTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationMetrics model) {
            costPerHour(model.costPerHour);
            costPerInference(model.costPerInference);
            maxInvocations(model.maxInvocations);
            modelLatency(model.modelLatency);
            cpuUtilization(model.cpuUtilization);
            memoryUtilization(model.memoryUtilization);
            modelSetupTime(model.modelSetupTime);
        }

        public final Float getCostPerHour() {
            return costPerHour;
        }

        public final void setCostPerHour(Float costPerHour) {
            this.costPerHour = costPerHour;
        }

        @Override
        public final Builder costPerHour(Float costPerHour) {
            this.costPerHour = costPerHour;
            return this;
        }

        public final Float getCostPerInference() {
            return costPerInference;
        }

        public final void setCostPerInference(Float costPerInference) {
            this.costPerInference = costPerInference;
        }

        @Override
        public final Builder costPerInference(Float costPerInference) {
            this.costPerInference = costPerInference;
            return this;
        }

        public final Integer getMaxInvocations() {
            return maxInvocations;
        }

        public final void setMaxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
        }

        @Override
        public final Builder maxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
            return this;
        }

        public final Integer getModelLatency() {
            return modelLatency;
        }

        public final void setModelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
        }

        @Override
        public final Builder modelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
            return this;
        }

        public final Float getCpuUtilization() {
            return cpuUtilization;
        }

        public final void setCpuUtilization(Float cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
        }

        @Override
        public final Builder cpuUtilization(Float cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
            return this;
        }

        public final Float getMemoryUtilization() {
            return memoryUtilization;
        }

        public final void setMemoryUtilization(Float memoryUtilization) {
            this.memoryUtilization = memoryUtilization;
        }

        @Override
        public final Builder memoryUtilization(Float memoryUtilization) {
            this.memoryUtilization = memoryUtilization;
            return this;
        }

        public final Integer getModelSetupTime() {
            return modelSetupTime;
        }

        public final void setModelSetupTime(Integer modelSetupTime) {
            this.modelSetupTime = modelSetupTime;
        }

        @Override
        public final Builder modelSetupTime(Integer modelSetupTime) {
            this.modelSetupTime = modelSetupTime;
            return this;
        }

        @Override
        public RecommendationMetrics build() {
            return new RecommendationMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
