/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the
 * results of the current job from the series of jobs scheduled to collect data periodically.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringBaselineConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringBaselineConfig.Builder, MonitoringBaselineConfig> {
    private static final SdkField<String> BASELINING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseliningJobName").getter(getter(MonitoringBaselineConfig::baseliningJobName))
            .setter(setter(Builder::baseliningJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseliningJobName").build()).build();

    private static final SdkField<MonitoringConstraintsResource> CONSTRAINTS_RESOURCE_FIELD = SdkField
            .<MonitoringConstraintsResource> builder(MarshallingType.SDK_POJO).memberName("ConstraintsResource")
            .getter(getter(MonitoringBaselineConfig::constraintsResource)).setter(setter(Builder::constraintsResource))
            .constructor(MonitoringConstraintsResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintsResource").build())
            .build();

    private static final SdkField<MonitoringStatisticsResource> STATISTICS_RESOURCE_FIELD = SdkField
            .<MonitoringStatisticsResource> builder(MarshallingType.SDK_POJO).memberName("StatisticsResource")
            .getter(getter(MonitoringBaselineConfig::statisticsResource)).setter(setter(Builder::statisticsResource))
            .constructor(MonitoringStatisticsResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticsResource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINING_JOB_NAME_FIELD,
            CONSTRAINTS_RESOURCE_FIELD, STATISTICS_RESOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String baseliningJobName;

    private final MonitoringConstraintsResource constraintsResource;

    private final MonitoringStatisticsResource statisticsResource;

    private MonitoringBaselineConfig(BuilderImpl builder) {
        this.baseliningJobName = builder.baseliningJobName;
        this.constraintsResource = builder.constraintsResource;
        this.statisticsResource = builder.statisticsResource;
    }

    /**
     * <p>
     * The name of the job that performs baselining for the monitoring job.
     * </p>
     * 
     * @return The name of the job that performs baselining for the monitoring job.
     */
    public final String baseliningJobName() {
        return baseliningJobName;
    }

    /**
     * <p>
     * The baseline constraint file in Amazon S3 that the current monitoring job should validated against.
     * </p>
     * 
     * @return The baseline constraint file in Amazon S3 that the current monitoring job should validated against.
     */
    public final MonitoringConstraintsResource constraintsResource() {
        return constraintsResource;
    }

    /**
     * <p>
     * The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
     * </p>
     * 
     * @return The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
     */
    public final MonitoringStatisticsResource statisticsResource() {
        return statisticsResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseliningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(constraintsResource());
        hashCode = 31 * hashCode + Objects.hashCode(statisticsResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringBaselineConfig)) {
            return false;
        }
        MonitoringBaselineConfig other = (MonitoringBaselineConfig) obj;
        return Objects.equals(baseliningJobName(), other.baseliningJobName())
                && Objects.equals(constraintsResource(), other.constraintsResource())
                && Objects.equals(statisticsResource(), other.statisticsResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringBaselineConfig").add("BaseliningJobName", baseliningJobName())
                .add("ConstraintsResource", constraintsResource()).add("StatisticsResource", statisticsResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseliningJobName":
            return Optional.ofNullable(clazz.cast(baseliningJobName()));
        case "ConstraintsResource":
            return Optional.ofNullable(clazz.cast(constraintsResource()));
        case "StatisticsResource":
            return Optional.ofNullable(clazz.cast(statisticsResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringBaselineConfig, T> g) {
        return obj -> g.apply((MonitoringBaselineConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringBaselineConfig> {
        /**
         * <p>
         * The name of the job that performs baselining for the monitoring job.
         * </p>
         * 
         * @param baseliningJobName
         *        The name of the job that performs baselining for the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseliningJobName(String baseliningJobName);

        /**
         * <p>
         * The baseline constraint file in Amazon S3 that the current monitoring job should validated against.
         * </p>
         * 
         * @param constraintsResource
         *        The baseline constraint file in Amazon S3 that the current monitoring job should validated against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintsResource(MonitoringConstraintsResource constraintsResource);

        /**
         * <p>
         * The baseline constraint file in Amazon S3 that the current monitoring job should validated against.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringConstraintsResource.Builder}
         * avoiding the need to create one manually via {@link MonitoringConstraintsResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringConstraintsResource.Builder#build()} is called
         * immediately and its result is passed to {@link #constraintsResource(MonitoringConstraintsResource)}.
         * 
         * @param constraintsResource
         *        a consumer that will call methods on {@link MonitoringConstraintsResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraintsResource(MonitoringConstraintsResource)
         */
        default Builder constraintsResource(Consumer<MonitoringConstraintsResource.Builder> constraintsResource) {
            return constraintsResource(MonitoringConstraintsResource.builder().applyMutation(constraintsResource).build());
        }

        /**
         * <p>
         * The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
         * </p>
         * 
         * @param statisticsResource
         *        The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsResource(MonitoringStatisticsResource statisticsResource);

        /**
         * <p>
         * The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringStatisticsResource.Builder}
         * avoiding the need to create one manually via {@link MonitoringStatisticsResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringStatisticsResource.Builder#build()} is called
         * immediately and its result is passed to {@link #statisticsResource(MonitoringStatisticsResource)}.
         * 
         * @param statisticsResource
         *        a consumer that will call methods on {@link MonitoringStatisticsResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statisticsResource(MonitoringStatisticsResource)
         */
        default Builder statisticsResource(Consumer<MonitoringStatisticsResource.Builder> statisticsResource) {
            return statisticsResource(MonitoringStatisticsResource.builder().applyMutation(statisticsResource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String baseliningJobName;

        private MonitoringConstraintsResource constraintsResource;

        private MonitoringStatisticsResource statisticsResource;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringBaselineConfig model) {
            baseliningJobName(model.baseliningJobName);
            constraintsResource(model.constraintsResource);
            statisticsResource(model.statisticsResource);
        }

        public final String getBaseliningJobName() {
            return baseliningJobName;
        }

        public final void setBaseliningJobName(String baseliningJobName) {
            this.baseliningJobName = baseliningJobName;
        }

        @Override
        public final Builder baseliningJobName(String baseliningJobName) {
            this.baseliningJobName = baseliningJobName;
            return this;
        }

        public final MonitoringConstraintsResource.Builder getConstraintsResource() {
            return constraintsResource != null ? constraintsResource.toBuilder() : null;
        }

        public final void setConstraintsResource(MonitoringConstraintsResource.BuilderImpl constraintsResource) {
            this.constraintsResource = constraintsResource != null ? constraintsResource.build() : null;
        }

        @Override
        public final Builder constraintsResource(MonitoringConstraintsResource constraintsResource) {
            this.constraintsResource = constraintsResource;
            return this;
        }

        public final MonitoringStatisticsResource.Builder getStatisticsResource() {
            return statisticsResource != null ? statisticsResource.toBuilder() : null;
        }

        public final void setStatisticsResource(MonitoringStatisticsResource.BuilderImpl statisticsResource) {
            this.statisticsResource = statisticsResource != null ? statisticsResource.build() : null;
        }

        @Override
        public final Builder statisticsResource(MonitoringStatisticsResource statisticsResource) {
            this.statisticsResource = statisticsResource;
            return this;
        }

        @Override
        public MonitoringBaselineConfig build() {
            return new MonitoringBaselineConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
