/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceRecommendationsJobStepsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListInferenceRecommendationsJobStepsRequest.Builder, ListInferenceRecommendationsJobStepsRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(ListInferenceRecommendationsJobStepsRequest::jobName))
            .setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListInferenceRecommendationsJobStepsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STEP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepType").getter(getter(ListInferenceRecommendationsJobStepsRequest::stepTypeAsString))
            .setter(setter(Builder::stepType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepType").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInferenceRecommendationsJobStepsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceRecommendationsJobStepsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, STATUS_FIELD,
            STEP_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String jobName;

    private final String status;

    private final String stepType;

    private final Integer maxResults;

    private final String nextToken;

    private ListInferenceRecommendationsJobStepsRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.stepType = builder.stepType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name for the Inference Recommender job.
     * </p>
     * 
     * @return The name for the Inference Recommender job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * A filter to return benchmarks of a specified status. If this field is left empty, then all benchmarks are
     * returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A filter to return benchmarks of a specified status. If this field is left empty, then all benchmarks are
     *         returned.
     * @see RecommendationJobStatus
     */
    public final RecommendationJobStatus status() {
        return RecommendationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * A filter to return benchmarks of a specified status. If this field is left empty, then all benchmarks are
     * returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A filter to return benchmarks of a specified status. If this field is left empty, then all benchmarks are
     *         returned.
     * @see RecommendationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A filter to return details about the specified type of subtask.
     * </p>
     * <p>
     * <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepType} will
     * return {@link RecommendationStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepTypeAsString}.
     * </p>
     * 
     * @return A filter to return details about the specified type of subtask.</p>
     *         <p>
     *         <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
     * @see RecommendationStepType
     */
    public final RecommendationStepType stepType() {
        return RecommendationStepType.fromValue(stepType);
    }

    /**
     * <p>
     * A filter to return details about the specified type of subtask.
     * </p>
     * <p>
     * <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepType} will
     * return {@link RecommendationStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepTypeAsString}.
     * </p>
     * 
     * @return A filter to return details about the specified type of subtask.</p>
     *         <p>
     *         <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
     * @see RecommendationStepType
     */
    public final String stepTypeAsString() {
        return stepType;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that you can specify to return more results from the list. Specify this field if you have a token that
     * was returned from a previous request.
     * </p>
     * 
     * @return A token that you can specify to return more results from the list. Specify this field if you have a token
     *         that was returned from a previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceRecommendationsJobStepsRequest)) {
            return false;
        }
        ListInferenceRecommendationsJobStepsRequest other = (ListInferenceRecommendationsJobStepsRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(stepTypeAsString(), other.stepTypeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceRecommendationsJobStepsRequest").add("JobName", jobName())
                .add("Status", statusAsString()).add("StepType", stepTypeAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StepType":
            return Optional.ofNullable(clazz.cast(stepTypeAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceRecommendationsJobStepsRequest, T> g) {
        return obj -> g.apply((ListInferenceRecommendationsJobStepsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInferenceRecommendationsJobStepsRequest> {
        /**
         * <p>
         * The name for the Inference Recommender job.
         * </p>
         * 
         * @param jobName
         *        The name for the Inference Recommender job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * A filter to return benchmarks of a specified status. If this field is left empty, then all benchmarks are
         * returned.
         * </p>
         * 
         * @param status
         *        A filter to return benchmarks of a specified status. If this field is left empty, then all benchmarks
         *        are returned.
         * @see RecommendationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A filter to return benchmarks of a specified status. If this field is left empty, then all benchmarks are
         * returned.
         * </p>
         * 
         * @param status
         *        A filter to return benchmarks of a specified status. If this field is left empty, then all benchmarks
         *        are returned.
         * @see RecommendationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobStatus
         */
        Builder status(RecommendationJobStatus status);

        /**
         * <p>
         * A filter to return details about the specified type of subtask.
         * </p>
         * <p>
         * <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
         * </p>
         * 
         * @param stepType
         *        A filter to return details about the specified type of subtask.</p>
         *        <p>
         *        <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
         * @see RecommendationStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStepType
         */
        Builder stepType(String stepType);

        /**
         * <p>
         * A filter to return details about the specified type of subtask.
         * </p>
         * <p>
         * <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
         * </p>
         * 
         * @param stepType
         *        A filter to return details about the specified type of subtask.</p>
         *        <p>
         *        <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.
         * @see RecommendationStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStepType
         */
        Builder stepType(RecommendationStepType stepType);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token that you can specify to return more results from the list. Specify this field if you have a token
         * that was returned from a previous request.
         * </p>
         * 
         * @param nextToken
         *        A token that you can specify to return more results from the list. Specify this field if you have a
         *        token that was returned from a previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String jobName;

        private String status;

        private String stepType;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceRecommendationsJobStepsRequest model) {
            super(model);
            jobName(model.jobName);
            status(model.status);
            stepType(model.stepType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStepType() {
            return stepType;
        }

        public final void setStepType(String stepType) {
            this.stepType = stepType;
        }

        @Override
        public final Builder stepType(String stepType) {
            this.stepType = stepType;
            return this;
        }

        @Override
        public final Builder stepType(RecommendationStepType stepType) {
            this.stepType(stepType == null ? null : stepType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceRecommendationsJobStepsRequest build() {
            return new ListInferenceRecommendationsJobStepsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
