/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceComponentsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListInferenceComponentsRequest.Builder, ListInferenceComponentsRequest> {
    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListInferenceComponentsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListInferenceComponentsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceComponentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInferenceComponentsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListInferenceComponentsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListInferenceComponentsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListInferenceComponentsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeBefore").getter(getter(ListInferenceComponentsRequest::lastModifiedTimeBefore))
            .setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeAfter").getter(getter(ListInferenceComponentsRequest::lastModifiedTimeAfter))
            .setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListInferenceComponentsRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> ENDPOINT_NAME_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointNameEquals").getter(getter(ListInferenceComponentsRequest::endpointNameEquals))
            .setter(setter(Builder::endpointNameEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointNameEquals").build())
            .build();

    private static final SdkField<String> VARIANT_NAME_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VariantNameEquals").getter(getter(ListInferenceComponentsRequest::variantNameEquals))
            .setter(setter(Builder::variantNameEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantNameEquals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_FIELD,
            SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, NAME_CONTAINS_FIELD, CREATION_TIME_BEFORE_FIELD,
            CREATION_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD, STATUS_EQUALS_FIELD,
            ENDPOINT_NAME_EQUALS_FIELD, VARIANT_NAME_EQUALS_FIELD));

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private final String nameContains;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private final String statusEquals;

    private final String endpointNameEquals;

    private final String variantNameEquals;

    private ListInferenceComponentsRequest(BuilderImpl builder) {
        super(builder);
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.statusEquals = builder.statusEquals;
        this.endpointNameEquals = builder.endpointNameEquals;
        this.variantNameEquals = builder.variantNameEquals;
    }

    /**
     * <p>
     * The field by which to sort the inference components in the response. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link InferenceComponentSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort the inference components in the response. The default is
     *         <code>CreationTime</code>.
     * @see InferenceComponentSortKey
     */
    public final InferenceComponentSortKey sortBy() {
        return InferenceComponentSortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * The field by which to sort the inference components in the response. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link InferenceComponentSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort the inference components in the response. The default is
     *         <code>CreationTime</code>.
     * @see InferenceComponentSortKey
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link OrderKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Descending</code>.
     * @see OrderKey
     */
    public final OrderKey sortOrder() {
        return OrderKey.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link OrderKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Descending</code>.
     * @see OrderKey
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * A token that you use to get the next set of results following a truncated response. If the response to the
     * previous request was truncated, that response provides the value for this token.
     * </p>
     * 
     * @return A token that you use to get the next set of results following a truncated response. If the response to
     *         the previous request was truncated, that response provides the value for this token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of inference components to return in the response. This value defaults to 10.
     * </p>
     * 
     * @return The maximum number of inference components to return in the response. This value defaults to 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filters the results to only those inference components with a name that contains the specified string.
     * </p>
     * 
     * @return Filters the results to only those inference components with a name that contains the specified string.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Filters the results to only those inference components that were created before the specified time.
     * </p>
     * 
     * @return Filters the results to only those inference components that were created before the specified time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Filters the results to only those inference components that were created after the specified time.
     * </p>
     * 
     * @return Filters the results to only those inference components that were created after the specified time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Filters the results to only those inference components that were updated before the specified time.
     * </p>
     * 
     * @return Filters the results to only those inference components that were updated before the specified time.
     */
    public final Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * Filters the results to only those inference components that were updated after the specified time.
     * </p>
     * 
     * @return Filters the results to only those inference components that were updated after the specified time.
     */
    public final Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    /**
     * <p>
     * Filters the results to only those inference components with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link InferenceComponentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Filters the results to only those inference components with the specified status.
     * @see InferenceComponentStatus
     */
    public final InferenceComponentStatus statusEquals() {
        return InferenceComponentStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * Filters the results to only those inference components with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link InferenceComponentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Filters the results to only those inference components with the specified status.
     * @see InferenceComponentStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * An endpoint name to filter the listed inference components. The response includes only those inference components
     * that are hosted at the specified endpoint.
     * </p>
     * 
     * @return An endpoint name to filter the listed inference components. The response includes only those inference
     *         components that are hosted at the specified endpoint.
     */
    public final String endpointNameEquals() {
        return endpointNameEquals;
    }

    /**
     * <p>
     * A production variant name to filter the listed inference components. The response includes only those inference
     * components that are hosted at the specified variant.
     * </p>
     * 
     * @return A production variant name to filter the listed inference components. The response includes only those
     *         inference components that are hosted at the specified variant.
     */
    public final String variantNameEquals() {
        return variantNameEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointNameEquals());
        hashCode = 31 * hashCode + Objects.hashCode(variantNameEquals());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceComponentsRequest)) {
            return false;
        }
        ListInferenceComponentsRequest other = (ListInferenceComponentsRequest) obj;
        return Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(endpointNameEquals(), other.endpointNameEquals())
                && Objects.equals(variantNameEquals(), other.variantNameEquals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceComponentsRequest").add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("NameContains", nameContains()).add("CreationTimeBefore", creationTimeBefore())
                .add("CreationTimeAfter", creationTimeAfter()).add("LastModifiedTimeBefore", lastModifiedTimeBefore())
                .add("LastModifiedTimeAfter", lastModifiedTimeAfter()).add("StatusEquals", statusEqualsAsString())
                .add("EndpointNameEquals", endpointNameEquals()).add("VariantNameEquals", variantNameEquals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "EndpointNameEquals":
            return Optional.ofNullable(clazz.cast(endpointNameEquals()));
        case "VariantNameEquals":
            return Optional.ofNullable(clazz.cast(variantNameEquals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceComponentsRequest, T> g) {
        return obj -> g.apply((ListInferenceComponentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInferenceComponentsRequest> {
        /**
         * <p>
         * The field by which to sort the inference components in the response. The default is <code>CreationTime</code>
         * .
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort the inference components in the response. The default is
         *        <code>CreationTime</code>.
         * @see InferenceComponentSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceComponentSortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field by which to sort the inference components in the response. The default is <code>CreationTime</code>
         * .
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort the inference components in the response. The default is
         *        <code>CreationTime</code>.
         * @see InferenceComponentSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceComponentSortKey
         */
        Builder sortBy(InferenceComponentSortKey sortBy);

        /**
         * <p>
         * The sort order for results. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Descending</code>.
         * @see OrderKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderKey
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for results. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Descending</code>.
         * @see OrderKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderKey
         */
        Builder sortOrder(OrderKey sortOrder);

        /**
         * <p>
         * A token that you use to get the next set of results following a truncated response. If the response to the
         * previous request was truncated, that response provides the value for this token.
         * </p>
         * 
         * @param nextToken
         *        A token that you use to get the next set of results following a truncated response. If the response to
         *        the previous request was truncated, that response provides the value for this token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of inference components to return in the response. This value defaults to 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of inference components to return in the response. This value defaults to 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters the results to only those inference components with a name that contains the specified string.
         * </p>
         * 
         * @param nameContains
         *        Filters the results to only those inference components with a name that contains the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Filters the results to only those inference components that were created before the specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        Filters the results to only those inference components that were created before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Filters the results to only those inference components that were created after the specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        Filters the results to only those inference components that were created after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Filters the results to only those inference components that were updated before the specified time.
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        Filters the results to only those inference components that were updated before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * Filters the results to only those inference components that were updated after the specified time.
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        Filters the results to only those inference components that were updated after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        /**
         * <p>
         * Filters the results to only those inference components with the specified status.
         * </p>
         * 
         * @param statusEquals
         *        Filters the results to only those inference components with the specified status.
         * @see InferenceComponentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceComponentStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * Filters the results to only those inference components with the specified status.
         * </p>
         * 
         * @param statusEquals
         *        Filters the results to only those inference components with the specified status.
         * @see InferenceComponentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceComponentStatus
         */
        Builder statusEquals(InferenceComponentStatus statusEquals);

        /**
         * <p>
         * An endpoint name to filter the listed inference components. The response includes only those inference
         * components that are hosted at the specified endpoint.
         * </p>
         * 
         * @param endpointNameEquals
         *        An endpoint name to filter the listed inference components. The response includes only those inference
         *        components that are hosted at the specified endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointNameEquals(String endpointNameEquals);

        /**
         * <p>
         * A production variant name to filter the listed inference components. The response includes only those
         * inference components that are hosted at the specified variant.
         * </p>
         * 
         * @param variantNameEquals
         *        A production variant name to filter the listed inference components. The response includes only those
         *        inference components that are hosted at the specified variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantNameEquals(String variantNameEquals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private String nameContains;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private Instant lastModifiedTimeBefore;

        private Instant lastModifiedTimeAfter;

        private String statusEquals;

        private String endpointNameEquals;

        private String variantNameEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceComponentsRequest model) {
            super(model);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            nameContains(model.nameContains);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            statusEquals(model.statusEquals);
            endpointNameEquals(model.endpointNameEquals);
            variantNameEquals(model.variantNameEquals);
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(InferenceComponentSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(OrderKey sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(InferenceComponentStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getEndpointNameEquals() {
            return endpointNameEquals;
        }

        public final void setEndpointNameEquals(String endpointNameEquals) {
            this.endpointNameEquals = endpointNameEquals;
        }

        @Override
        public final Builder endpointNameEquals(String endpointNameEquals) {
            this.endpointNameEquals = endpointNameEquals;
            return this;
        }

        public final String getVariantNameEquals() {
            return variantNameEquals;
        }

        public final void setVariantNameEquals(String variantNameEquals) {
            this.variantNameEquals = variantNameEquals;
        }

        @Override
        public final Builder variantNameEquals(String variantNameEquals) {
            this.variantNameEquals = variantNameEquals;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceComponentsRequest build() {
            return new ListInferenceComponentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
