/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePresignedDomainUrlRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreatePresignedDomainUrlRequest.Builder, CreatePresignedDomainUrlRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(CreatePresignedDomainUrlRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(CreatePresignedDomainUrlRequest::userProfileName))
            .setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<Integer> SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionExpirationDurationInSeconds")
            .getter(getter(CreatePresignedDomainUrlRequest::sessionExpirationDurationInSeconds))
            .setter(setter(Builder::sessionExpirationDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionExpirationDurationInSeconds")
                    .build()).build();

    private static final SdkField<Integer> EXPIRES_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpiresInSeconds").getter(getter(CreatePresignedDomainUrlRequest::expiresInSeconds))
            .setter(setter(Builder::expiresInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresInSeconds").build()).build();

    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceName").getter(getter(CreatePresignedDomainUrlRequest::spaceName))
            .setter(setter(Builder::spaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()).build();

    private static final SdkField<String> LANDING_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LandingUri").getter(getter(CreatePresignedDomainUrlRequest::landingUri))
            .setter(setter(Builder::landingUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LandingUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            USER_PROFILE_NAME_FIELD, SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD, EXPIRES_IN_SECONDS_FIELD, SPACE_NAME_FIELD,
            LANDING_URI_FIELD));

    private final String domainId;

    private final String userProfileName;

    private final Integer sessionExpirationDurationInSeconds;

    private final Integer expiresInSeconds;

    private final String spaceName;

    private final String landingUri;

    private CreatePresignedDomainUrlRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.sessionExpirationDurationInSeconds = builder.sessionExpirationDurationInSeconds;
        this.expiresInSeconds = builder.expiresInSeconds;
        this.spaceName = builder.spaceName;
        this.landingUri = builder.landingUri;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of the UserProfile to sign-in as.
     * </p>
     * 
     * @return The name of the UserProfile to sign-in as.
     */
    public final String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * The session expiration duration in seconds. This value defaults to 43200.
     * </p>
     * 
     * @return The session expiration duration in seconds. This value defaults to 43200.
     */
    public final Integer sessionExpirationDurationInSeconds() {
        return sessionExpirationDurationInSeconds;
    }

    /**
     * <p>
     * The number of seconds until the pre-signed URL expires. This value defaults to 300.
     * </p>
     * 
     * @return The number of seconds until the pre-signed URL expires. This value defaults to 300.
     */
    public final Integer expiresInSeconds() {
        return expiresInSeconds;
    }

    /**
     * <p>
     * The name of the space.
     * </p>
     * 
     * @return The name of the space.
     */
    public final String spaceName() {
        return spaceName;
    }

    /**
     * <p>
     * The landing page that the user is directed to when accessing the presigned URL. Using this value, users can
     * access Studio or Studio Classic, even if it is not the default experience for the domain. The supported values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>studio::relative/path</code>: Directs users to the relative path in Studio.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>app:JupyterServer:relative/path</code>: Directs users to the relative path in the Studio Classic
     * application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>app:JupyterLab:relative/path</code>: Directs users to the relative path in the JupyterLab application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>app:RStudioServerPro:relative/path</code>: Directs users to the relative path in the RStudio application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>app:CodeEditor:relative/path</code>: Directs users to the relative path in the Code Editor, based on
     * Code-OSS, Visual Studio Code - Open Source application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>app:Canvas:relative/path</code>: Directs users to the relative path in the Canvas application.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The landing page that the user is directed to when accessing the presigned URL. Using this value, users
     *         can access Studio or Studio Classic, even if it is not the default experience for the domain. The
     *         supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>studio::relative/path</code>: Directs users to the relative path in Studio.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>app:JupyterServer:relative/path</code>: Directs users to the relative path in the Studio Classic
     *         application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>app:JupyterLab:relative/path</code>: Directs users to the relative path in the JupyterLab
     *         application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>app:RStudioServerPro:relative/path</code>: Directs users to the relative path in the RStudio
     *         application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>app:CodeEditor:relative/path</code>: Directs users to the relative path in the Code Editor, based
     *         on Code-OSS, Visual Studio Code - Open Source application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>app:Canvas:relative/path</code>: Directs users to the relative path in the Canvas application.
     *         </p>
     *         </li>
     */
    public final String landingUri() {
        return landingUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(sessionExpirationDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(expiresInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(landingUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedDomainUrlRequest)) {
            return false;
        }
        CreatePresignedDomainUrlRequest other = (CreatePresignedDomainUrlRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(userProfileName(), other.userProfileName())
                && Objects.equals(sessionExpirationDurationInSeconds(), other.sessionExpirationDurationInSeconds())
                && Objects.equals(expiresInSeconds(), other.expiresInSeconds()) && Objects.equals(spaceName(), other.spaceName())
                && Objects.equals(landingUri(), other.landingUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePresignedDomainUrlRequest").add("DomainId", domainId())
                .add("UserProfileName", userProfileName())
                .add("SessionExpirationDurationInSeconds", sessionExpirationDurationInSeconds())
                .add("ExpiresInSeconds", expiresInSeconds()).add("SpaceName", spaceName()).add("LandingUri", landingUri())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "SessionExpirationDurationInSeconds":
            return Optional.ofNullable(clazz.cast(sessionExpirationDurationInSeconds()));
        case "ExpiresInSeconds":
            return Optional.ofNullable(clazz.cast(expiresInSeconds()));
        case "SpaceName":
            return Optional.ofNullable(clazz.cast(spaceName()));
        case "LandingUri":
            return Optional.ofNullable(clazz.cast(landingUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedDomainUrlRequest, T> g) {
        return obj -> g.apply((CreatePresignedDomainUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePresignedDomainUrlRequest> {
        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of the UserProfile to sign-in as.
         * </p>
         * 
         * @param userProfileName
         *        The name of the UserProfile to sign-in as.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * The session expiration duration in seconds. This value defaults to 43200.
         * </p>
         * 
         * @param sessionExpirationDurationInSeconds
         *        The session expiration duration in seconds. This value defaults to 43200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds);

        /**
         * <p>
         * The number of seconds until the pre-signed URL expires. This value defaults to 300.
         * </p>
         * 
         * @param expiresInSeconds
         *        The number of seconds until the pre-signed URL expires. This value defaults to 300.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresInSeconds(Integer expiresInSeconds);

        /**
         * <p>
         * The name of the space.
         * </p>
         * 
         * @param spaceName
         *        The name of the space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceName(String spaceName);

        /**
         * <p>
         * The landing page that the user is directed to when accessing the presigned URL. Using this value, users can
         * access Studio or Studio Classic, even if it is not the default experience for the domain. The supported
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>studio::relative/path</code>: Directs users to the relative path in Studio.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>app:JupyterServer:relative/path</code>: Directs users to the relative path in the Studio Classic
         * application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>app:JupyterLab:relative/path</code>: Directs users to the relative path in the JupyterLab application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>app:RStudioServerPro:relative/path</code>: Directs users to the relative path in the RStudio
         * application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>app:CodeEditor:relative/path</code>: Directs users to the relative path in the Code Editor, based on
         * Code-OSS, Visual Studio Code - Open Source application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>app:Canvas:relative/path</code>: Directs users to the relative path in the Canvas application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param landingUri
         *        The landing page that the user is directed to when accessing the presigned URL. Using this value,
         *        users can access Studio or Studio Classic, even if it is not the default experience for the domain.
         *        The supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>studio::relative/path</code>: Directs users to the relative path in Studio.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>app:JupyterServer:relative/path</code>: Directs users to the relative path in the Studio Classic
         *        application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>app:JupyterLab:relative/path</code>: Directs users to the relative path in the JupyterLab
         *        application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>app:RStudioServerPro:relative/path</code>: Directs users to the relative path in the RStudio
         *        application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>app:CodeEditor:relative/path</code>: Directs users to the relative path in the Code Editor,
         *        based on Code-OSS, Visual Studio Code - Open Source application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>app:Canvas:relative/path</code>: Directs users to the relative path in the Canvas application.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landingUri(String landingUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private String userProfileName;

        private Integer sessionExpirationDurationInSeconds;

        private Integer expiresInSeconds;

        private String spaceName;

        private String landingUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedDomainUrlRequest model) {
            super(model);
            domainId(model.domainId);
            userProfileName(model.userProfileName);
            sessionExpirationDurationInSeconds(model.sessionExpirationDurationInSeconds);
            expiresInSeconds(model.expiresInSeconds);
            spaceName(model.spaceName);
            landingUri(model.landingUri);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final Integer getSessionExpirationDurationInSeconds() {
            return sessionExpirationDurationInSeconds;
        }

        public final void setSessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
        }

        @Override
        public final Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
            return this;
        }

        public final Integer getExpiresInSeconds() {
            return expiresInSeconds;
        }

        public final void setExpiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
        }

        @Override
        public final Builder expiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
            return this;
        }

        public final String getSpaceName() {
            return spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getLandingUri() {
            return landingUri;
        }

        public final void setLandingUri(String landingUri) {
            this.landingUri = landingUri;
        }

        @Override
        public final Builder landingUri(String landingUri) {
            this.landingUri = landingUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresignedDomainUrlRequest build() {
            return new CreatePresignedDomainUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
