/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specifications of an instance group that you need to define.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterInstanceGroupSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterInstanceGroupSpecification.Builder, ClusterInstanceGroupSpecification> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(ClusterInstanceGroupSpecification::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(ClusterInstanceGroupSpecification::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ClusterInstanceGroupSpecification::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<ClusterLifeCycleConfig> LIFE_CYCLE_CONFIG_FIELD = SdkField
            .<ClusterLifeCycleConfig> builder(MarshallingType.SDK_POJO).memberName("LifeCycleConfig")
            .getter(getter(ClusterInstanceGroupSpecification::lifeCycleConfig)).setter(setter(Builder::lifeCycleConfig))
            .constructor(ClusterLifeCycleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleConfig").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRole").getter(getter(ClusterInstanceGroupSpecification::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()).build();

    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThreadsPerCore").getter(getter(ClusterInstanceGroupSpecification::threadsPerCore))
            .setter(setter(Builder::threadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INSTANCE_COUNT_FIELD, INSTANCE_GROUP_NAME_FIELD, INSTANCE_TYPE_FIELD, LIFE_CYCLE_CONFIG_FIELD,
                    EXECUTION_ROLE_FIELD, THREADS_PER_CORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer instanceCount;

    private final String instanceGroupName;

    private final String instanceType;

    private final ClusterLifeCycleConfig lifeCycleConfig;

    private final String executionRole;

    private final Integer threadsPerCore;

    private ClusterInstanceGroupSpecification(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceType = builder.instanceType;
        this.lifeCycleConfig = builder.lifeCycleConfig;
        this.executionRole = builder.executionRole;
        this.threadsPerCore = builder.threadsPerCore;
    }

    /**
     * <p>
     * Specifies the number of instances to add to the instance group of a SageMaker HyperPod cluster.
     * </p>
     * 
     * @return Specifies the number of instances to add to the instance group of a SageMaker HyperPod cluster.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * Specifies the name of the instance group.
     * </p>
     * 
     * @return Specifies the name of the instance group.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    /**
     * <p>
     * Specifies the instance type of the instance group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return Specifies the instance type of the instance group.
     * @see ClusterInstanceType
     */
    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * Specifies the instance type of the instance group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return Specifies the instance type of the instance group.
     * @see ClusterInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * Specifies the LifeCycle configuration for the instance group.
     * </p>
     * 
     * @return Specifies the LifeCycle configuration for the instance group.
     */
    public final ClusterLifeCycleConfig lifeCycleConfig() {
        return lifeCycleConfig;
    }

    /**
     * <p>
     * Specifies an IAM execution role to be assumed by the instance group.
     * </p>
     * 
     * @return Specifies an IAM execution role to be assumed by the instance group.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * Specifies the value for <b>Threads per core</b>. For instance types that support multithreading, you can specify
     * <code>1</code> for disabling multithreading and <code>2</code> for enabling multithreading. For instance types
     * that doesn't support multithreading, specify <code>1</code>. For more information, see the reference table of <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html">CPU cores
     * and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies the value for <b>Threads per core</b>. For instance types that support multithreading, you can
     *         specify <code>1</code> for disabling multithreading and <code>2</code> for enabling multithreading. For
     *         instance types that doesn't support multithreading, specify <code>1</code>. For more information, see the
     *         reference table of <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html"
     *         >CPU cores and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User
     *         Guide</i>.
     */
    public final Integer threadsPerCore() {
        return threadsPerCore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(threadsPerCore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInstanceGroupSpecification)) {
            return false;
        }
        ClusterInstanceGroupSpecification other = (ClusterInstanceGroupSpecification) obj;
        return Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(instanceGroupName(), other.instanceGroupName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(lifeCycleConfig(), other.lifeCycleConfig())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(threadsPerCore(), other.threadsPerCore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterInstanceGroupSpecification").add("InstanceCount", instanceCount())
                .add("InstanceGroupName", instanceGroupName()).add("InstanceType", instanceTypeAsString())
                .add("LifeCycleConfig", lifeCycleConfig()).add("ExecutionRole", executionRole())
                .add("ThreadsPerCore", threadsPerCore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "LifeCycleConfig":
            return Optional.ofNullable(clazz.cast(lifeCycleConfig()));
        case "ExecutionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "ThreadsPerCore":
            return Optional.ofNullable(clazz.cast(threadsPerCore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterInstanceGroupSpecification, T> g) {
        return obj -> g.apply((ClusterInstanceGroupSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterInstanceGroupSpecification> {
        /**
         * <p>
         * Specifies the number of instances to add to the instance group of a SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceCount
         *        Specifies the number of instances to add to the instance group of a SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * Specifies the name of the instance group.
         * </p>
         * 
         * @param instanceGroupName
         *        Specifies the name of the instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);

        /**
         * <p>
         * Specifies the instance type of the instance group.
         * </p>
         * 
         * @param instanceType
         *        Specifies the instance type of the instance group.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Specifies the instance type of the instance group.
         * </p>
         * 
         * @param instanceType
         *        Specifies the instance type of the instance group.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(ClusterInstanceType instanceType);

        /**
         * <p>
         * Specifies the LifeCycle configuration for the instance group.
         * </p>
         * 
         * @param lifeCycleConfig
         *        Specifies the LifeCycle configuration for the instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig);

        /**
         * <p>
         * Specifies the LifeCycle configuration for the instance group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterLifeCycleConfig.Builder} avoiding
         * the need to create one manually via {@link ClusterLifeCycleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterLifeCycleConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lifeCycleConfig(ClusterLifeCycleConfig)}.
         * 
         * @param lifeCycleConfig
         *        a consumer that will call methods on {@link ClusterLifeCycleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycleConfig(ClusterLifeCycleConfig)
         */
        default Builder lifeCycleConfig(Consumer<ClusterLifeCycleConfig.Builder> lifeCycleConfig) {
            return lifeCycleConfig(ClusterLifeCycleConfig.builder().applyMutation(lifeCycleConfig).build());
        }

        /**
         * <p>
         * Specifies an IAM execution role to be assumed by the instance group.
         * </p>
         * 
         * @param executionRole
         *        Specifies an IAM execution role to be assumed by the instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * Specifies the value for <b>Threads per core</b>. For instance types that support multithreading, you can
         * specify <code>1</code> for disabling multithreading and <code>2</code> for enabling multithreading. For
         * instance types that doesn't support multithreading, specify <code>1</code>. For more information, see the
         * reference table of <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html">CPU
         * cores and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param threadsPerCore
         *        Specifies the value for <b>Threads per core</b>. For instance types that support multithreading, you
         *        can specify <code>1</code> for disabling multithreading and <code>2</code> for enabling
         *        multithreading. For instance types that doesn't support multithreading, specify <code>1</code>. For
         *        more information, see the reference table of <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html">CPU
         *        cores and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadsPerCore(Integer threadsPerCore);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String instanceGroupName;

        private String instanceType;

        private ClusterLifeCycleConfig lifeCycleConfig;

        private String executionRole;

        private Integer threadsPerCore;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInstanceGroupSpecification model) {
            instanceCount(model.instanceCount);
            instanceGroupName(model.instanceGroupName);
            instanceType(model.instanceType);
            lifeCycleConfig(model.lifeCycleConfig);
            executionRole(model.executionRole);
            threadsPerCore(model.threadsPerCore);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final ClusterLifeCycleConfig.Builder getLifeCycleConfig() {
            return lifeCycleConfig != null ? lifeCycleConfig.toBuilder() : null;
        }

        public final void setLifeCycleConfig(ClusterLifeCycleConfig.BuilderImpl lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig != null ? lifeCycleConfig.build() : null;
        }

        @Override
        public final Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        @Override
        public ClusterInstanceGroupSpecification build() {
            return new ClusterInstanceGroupSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
