/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resolved attributes used to configure an AutoML job V2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLResolvedAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLResolvedAttributes.Builder, AutoMLResolvedAttributes> {
    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField
            .<AutoMLJobObjective> builder(MarshallingType.SDK_POJO).memberName("AutoMLJobObjective")
            .getter(getter(AutoMLResolvedAttributes::autoMLJobObjective)).setter(setter(Builder::autoMLJobObjective))
            .constructor(AutoMLJobObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build())
            .build();

    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField
            .<AutoMLJobCompletionCriteria> builder(MarshallingType.SDK_POJO).memberName("CompletionCriteria")
            .getter(getter(AutoMLResolvedAttributes::completionCriteria)).setter(setter(Builder::completionCriteria))
            .constructor(AutoMLJobCompletionCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build())
            .build();

    private static final SdkField<AutoMLProblemTypeResolvedAttributes> AUTO_ML_PROBLEM_TYPE_RESOLVED_ATTRIBUTES_FIELD = SdkField
            .<AutoMLProblemTypeResolvedAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("AutoMLProblemTypeResolvedAttributes")
            .getter(getter(AutoMLResolvedAttributes::autoMLProblemTypeResolvedAttributes))
            .setter(setter(Builder::autoMLProblemTypeResolvedAttributes))
            .constructor(AutoMLProblemTypeResolvedAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AutoMLProblemTypeResolvedAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_OBJECTIVE_FIELD,
            COMPLETION_CRITERIA_FIELD, AUTO_ML_PROBLEM_TYPE_RESOLVED_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoMLJobObjective autoMLJobObjective;

    private final AutoMLJobCompletionCriteria completionCriteria;

    private final AutoMLProblemTypeResolvedAttributes autoMLProblemTypeResolvedAttributes;

    private AutoMLResolvedAttributes(BuilderImpl builder) {
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.completionCriteria = builder.completionCriteria;
        this.autoMLProblemTypeResolvedAttributes = builder.autoMLProblemTypeResolvedAttributes;
    }

    /**
     * Returns the value of the AutoMLJobObjective property for this object.
     * 
     * @return The value of the AutoMLJobObjective property for this object.
     */
    public final AutoMLJobObjective autoMLJobObjective() {
        return autoMLJobObjective;
    }

    /**
     * Returns the value of the CompletionCriteria property for this object.
     * 
     * @return The value of the CompletionCriteria property for this object.
     */
    public final AutoMLJobCompletionCriteria completionCriteria() {
        return completionCriteria;
    }

    /**
     * <p>
     * Defines the resolved attributes specific to a problem type.
     * </p>
     * 
     * @return Defines the resolved attributes specific to a problem type.
     */
    public final AutoMLProblemTypeResolvedAttributes autoMLProblemTypeResolvedAttributes() {
        return autoMLProblemTypeResolvedAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLProblemTypeResolvedAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLResolvedAttributes)) {
            return false;
        }
        AutoMLResolvedAttributes other = (AutoMLResolvedAttributes) obj;
        return Objects.equals(autoMLJobObjective(), other.autoMLJobObjective())
                && Objects.equals(completionCriteria(), other.completionCriteria())
                && Objects.equals(autoMLProblemTypeResolvedAttributes(), other.autoMLProblemTypeResolvedAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLResolvedAttributes").add("AutoMLJobObjective", autoMLJobObjective())
                .add("CompletionCriteria", completionCriteria())
                .add("AutoMLProblemTypeResolvedAttributes", autoMLProblemTypeResolvedAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLJobObjective":
            return Optional.ofNullable(clazz.cast(autoMLJobObjective()));
        case "CompletionCriteria":
            return Optional.ofNullable(clazz.cast(completionCriteria()));
        case "AutoMLProblemTypeResolvedAttributes":
            return Optional.ofNullable(clazz.cast(autoMLProblemTypeResolvedAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLResolvedAttributes, T> g) {
        return obj -> g.apply((AutoMLResolvedAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLResolvedAttributes> {
        /**
         * Sets the value of the AutoMLJobObjective property for this object.
         *
         * @param autoMLJobObjective
         *        The new value for the AutoMLJobObjective property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective);

        /**
         * Sets the value of the AutoMLJobObjective property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoMLJobObjective.Builder} avoiding the
         * need to create one manually via {@link AutoMLJobObjective#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobObjective.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobObjective(AutoMLJobObjective)}.
         * 
         * @param autoMLJobObjective
         *        a consumer that will call methods on {@link AutoMLJobObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobObjective(AutoMLJobObjective)
         */
        default Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return autoMLJobObjective(AutoMLJobObjective.builder().applyMutation(autoMLJobObjective).build());
        }

        /**
         * Sets the value of the CompletionCriteria property for this object.
         *
         * @param completionCriteria
         *        The new value for the CompletionCriteria property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria);

        /**
         * Sets the value of the CompletionCriteria property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoMLJobCompletionCriteria.Builder}
         * avoiding the need to create one manually via {@link AutoMLJobCompletionCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobCompletionCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #completionCriteria(AutoMLJobCompletionCriteria)}.
         * 
         * @param completionCriteria
         *        a consumer that will call methods on {@link AutoMLJobCompletionCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completionCriteria(AutoMLJobCompletionCriteria)
         */
        default Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return completionCriteria(AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria).build());
        }

        /**
         * <p>
         * Defines the resolved attributes specific to a problem type.
         * </p>
         * 
         * @param autoMLProblemTypeResolvedAttributes
         *        Defines the resolved attributes specific to a problem type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLProblemTypeResolvedAttributes(AutoMLProblemTypeResolvedAttributes autoMLProblemTypeResolvedAttributes);

        /**
         * <p>
         * Defines the resolved attributes specific to a problem type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutoMLProblemTypeResolvedAttributes.Builder} avoiding the need to create one manually via
         * {@link AutoMLProblemTypeResolvedAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLProblemTypeResolvedAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #autoMLProblemTypeResolvedAttributes(AutoMLProblemTypeResolvedAttributes)}.
         * 
         * @param autoMLProblemTypeResolvedAttributes
         *        a consumer that will call methods on {@link AutoMLProblemTypeResolvedAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLProblemTypeResolvedAttributes(AutoMLProblemTypeResolvedAttributes)
         */
        default Builder autoMLProblemTypeResolvedAttributes(
                Consumer<AutoMLProblemTypeResolvedAttributes.Builder> autoMLProblemTypeResolvedAttributes) {
            return autoMLProblemTypeResolvedAttributes(AutoMLProblemTypeResolvedAttributes.builder()
                    .applyMutation(autoMLProblemTypeResolvedAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoMLJobObjective autoMLJobObjective;

        private AutoMLJobCompletionCriteria completionCriteria;

        private AutoMLProblemTypeResolvedAttributes autoMLProblemTypeResolvedAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLResolvedAttributes model) {
            autoMLJobObjective(model.autoMLJobObjective);
            completionCriteria(model.completionCriteria);
            autoMLProblemTypeResolvedAttributes(model.autoMLProblemTypeResolvedAttributes);
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return autoMLJobObjective != null ? autoMLJobObjective.toBuilder() : null;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return completionCriteria != null ? completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final AutoMLProblemTypeResolvedAttributes.Builder getAutoMLProblemTypeResolvedAttributes() {
            return autoMLProblemTypeResolvedAttributes != null ? autoMLProblemTypeResolvedAttributes.toBuilder() : null;
        }

        public final void setAutoMLProblemTypeResolvedAttributes(
                AutoMLProblemTypeResolvedAttributes.BuilderImpl autoMLProblemTypeResolvedAttributes) {
            this.autoMLProblemTypeResolvedAttributes = autoMLProblemTypeResolvedAttributes != null ? autoMLProblemTypeResolvedAttributes
                    .build() : null;
        }

        @Override
        public final Builder autoMLProblemTypeResolvedAttributes(
                AutoMLProblemTypeResolvedAttributes autoMLProblemTypeResolvedAttributes) {
            this.autoMLProblemTypeResolvedAttributes = autoMLProblemTypeResolvedAttributes;
            return this;
        }

        @Override
        public AutoMLResolvedAttributes build() {
            return new AutoMLResolvedAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
