/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.CompilationJobSummary;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse;

public class ListCompilationJobsPublisher
implements SdkPublisher<ListCompilationJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListCompilationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCompilationJobsPublisher(SageMakerAsyncClient client, ListCompilationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCompilationJobsPublisher(SageMakerAsyncClient client, ListCompilationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCompilationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCompilationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CompilationJobSummary> compilationJobSummaries() {
        Function<ListCompilationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.compilationJobSummaries() != null) {
                return response.compilationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCompilationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCompilationJobsResponseFetcher
    implements AsyncPageFetcher<ListCompilationJobsResponse> {
        private ListCompilationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCompilationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCompilationJobsResponse> nextPage(ListCompilationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCompilationJobsPublisher.this.client.listCompilationJobs(ListCompilationJobsPublisher.this.firstRequest);
            }
            return ListCompilationJobsPublisher.this.client.listCompilationJobs((ListCompilationJobsRequest)((Object)ListCompilationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

