/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePresignedDomainUrlRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreatePresignedDomainUrlRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(CreatePresignedDomainUrlRequest.getter(CreatePresignedDomainUrlRequest::domainId)).setter(CreatePresignedDomainUrlRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileName").getter(CreatePresignedDomainUrlRequest.getter(CreatePresignedDomainUrlRequest::userProfileName)).setter(CreatePresignedDomainUrlRequest.setter(Builder::userProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()}).build();
    private static final SdkField<Integer> SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionExpirationDurationInSeconds").getter(CreatePresignedDomainUrlRequest.getter(CreatePresignedDomainUrlRequest::sessionExpirationDurationInSeconds)).setter(CreatePresignedDomainUrlRequest.setter(Builder::sessionExpirationDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionExpirationDurationInSeconds").build()}).build();
    private static final SdkField<Integer> EXPIRES_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpiresInSeconds").getter(CreatePresignedDomainUrlRequest.getter(CreatePresignedDomainUrlRequest::expiresInSeconds)).setter(CreatePresignedDomainUrlRequest.setter(Builder::expiresInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresInSeconds").build()}).build();
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceName").getter(CreatePresignedDomainUrlRequest.getter(CreatePresignedDomainUrlRequest::spaceName)).setter(CreatePresignedDomainUrlRequest.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()}).build();
    private static final SdkField<String> LANDING_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LandingUri").getter(CreatePresignedDomainUrlRequest.getter(CreatePresignedDomainUrlRequest::landingUri)).setter(CreatePresignedDomainUrlRequest.setter(Builder::landingUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LandingUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, USER_PROFILE_NAME_FIELD, SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD, EXPIRES_IN_SECONDS_FIELD, SPACE_NAME_FIELD, LANDING_URI_FIELD));
    private final String domainId;
    private final String userProfileName;
    private final Integer sessionExpirationDurationInSeconds;
    private final Integer expiresInSeconds;
    private final String spaceName;
    private final String landingUri;

    private CreatePresignedDomainUrlRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.sessionExpirationDurationInSeconds = builder.sessionExpirationDurationInSeconds;
        this.expiresInSeconds = builder.expiresInSeconds;
        this.spaceName = builder.spaceName;
        this.landingUri = builder.landingUri;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String userProfileName() {
        return this.userProfileName;
    }

    public final Integer sessionExpirationDurationInSeconds() {
        return this.sessionExpirationDurationInSeconds;
    }

    public final Integer expiresInSeconds() {
        return this.expiresInSeconds;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String landingUri() {
        return this.landingUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionExpirationDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.landingUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedDomainUrlRequest)) {
            return false;
        }
        CreatePresignedDomainUrlRequest other = (CreatePresignedDomainUrlRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.userProfileName(), other.userProfileName()) && Objects.equals(this.sessionExpirationDurationInSeconds(), other.sessionExpirationDurationInSeconds()) && Objects.equals(this.expiresInSeconds(), other.expiresInSeconds()) && Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.landingUri(), other.landingUri());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePresignedDomainUrlRequest").add("DomainId", (Object)this.domainId()).add("UserProfileName", (Object)this.userProfileName()).add("SessionExpirationDurationInSeconds", (Object)this.sessionExpirationDurationInSeconds()).add("ExpiresInSeconds", (Object)this.expiresInSeconds()).add("SpaceName", (Object)this.spaceName()).add("LandingUri", (Object)this.landingUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "UserProfileName": {
                return Optional.ofNullable(clazz.cast(this.userProfileName()));
            }
            case "SessionExpirationDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionExpirationDurationInSeconds()));
            }
            case "ExpiresInSeconds": {
                return Optional.ofNullable(clazz.cast(this.expiresInSeconds()));
            }
            case "SpaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "LandingUri": {
                return Optional.ofNullable(clazz.cast(this.landingUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedDomainUrlRequest, T> g) {
        return obj -> g.apply((CreatePresignedDomainUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private String userProfileName;
        private Integer sessionExpirationDurationInSeconds;
        private Integer expiresInSeconds;
        private String spaceName;
        private String landingUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedDomainUrlRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.userProfileName(model.userProfileName);
            this.sessionExpirationDurationInSeconds(model.sessionExpirationDurationInSeconds);
            this.expiresInSeconds(model.expiresInSeconds);
            this.spaceName(model.spaceName);
            this.landingUri(model.landingUri);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getUserProfileName() {
            return this.userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final Integer getSessionExpirationDurationInSeconds() {
            return this.sessionExpirationDurationInSeconds;
        }

        public final void setSessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
        }

        @Override
        public final Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
            return this;
        }

        public final Integer getExpiresInSeconds() {
            return this.expiresInSeconds;
        }

        public final void setExpiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
        }

        @Override
        public final Builder expiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
            return this;
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getLandingUri() {
            return this.landingUri;
        }

        public final void setLandingUri(String landingUri) {
            this.landingUri = landingUri;
        }

        @Override
        public final Builder landingUri(String landingUri) {
            this.landingUri = landingUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresignedDomainUrlRequest build() {
            return new CreatePresignedDomainUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePresignedDomainUrlRequest> {
        public Builder domainId(String var1);

        public Builder userProfileName(String var1);

        public Builder sessionExpirationDurationInSeconds(Integer var1);

        public Builder expiresInSeconds(Integer var1);

        public Builder spaceName(String var1);

        public Builder landingUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

