/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkforceStatus {
    INITIALIZING("Initializing"),
    UPDATING("Updating"),
    DELETING("Deleting"),
    FAILED("Failed"),
    ACTIVE("Active"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkforceStatus> VALUE_MAP;
    private final String value;

    private WorkforceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkforceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkforceStatus> knownValues() {
        EnumSet<WorkforceStatus> knownValues = EnumSet.allOf(WorkforceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkforceStatus.class, WorkforceStatus::toString);
    }
}

