/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.JupyterLabAppImageConfig;
import software.amazon.awssdk.services.sagemaker.model.KernelGatewayImageConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppImageConfigRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateAppImageConfigRequest> {
    private static final SdkField<String> APP_IMAGE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppImageConfigName").getter(CreateAppImageConfigRequest.getter(CreateAppImageConfigRequest::appImageConfigName)).setter(CreateAppImageConfigRequest.setter(Builder::appImageConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAppImageConfigRequest.getter(CreateAppImageConfigRequest::tags)).setter(CreateAppImageConfigRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<KernelGatewayImageConfig> KERNEL_GATEWAY_IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KernelGatewayImageConfig").getter(CreateAppImageConfigRequest.getter(CreateAppImageConfigRequest::kernelGatewayImageConfig)).setter(CreateAppImageConfigRequest.setter(Builder::kernelGatewayImageConfig)).constructor(KernelGatewayImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayImageConfig").build()}).build();
    private static final SdkField<JupyterLabAppImageConfig> JUPYTER_LAB_APP_IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JupyterLabAppImageConfig").getter(CreateAppImageConfigRequest.getter(CreateAppImageConfigRequest::jupyterLabAppImageConfig)).setter(CreateAppImageConfigRequest.setter(Builder::jupyterLabAppImageConfig)).constructor(JupyterLabAppImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterLabAppImageConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_IMAGE_CONFIG_NAME_FIELD, TAGS_FIELD, KERNEL_GATEWAY_IMAGE_CONFIG_FIELD, JUPYTER_LAB_APP_IMAGE_CONFIG_FIELD));
    private final String appImageConfigName;
    private final List<Tag> tags;
    private final KernelGatewayImageConfig kernelGatewayImageConfig;
    private final JupyterLabAppImageConfig jupyterLabAppImageConfig;

    private CreateAppImageConfigRequest(BuilderImpl builder) {
        super(builder);
        this.appImageConfigName = builder.appImageConfigName;
        this.tags = builder.tags;
        this.kernelGatewayImageConfig = builder.kernelGatewayImageConfig;
        this.jupyterLabAppImageConfig = builder.jupyterLabAppImageConfig;
    }

    public final String appImageConfigName() {
        return this.appImageConfigName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final KernelGatewayImageConfig kernelGatewayImageConfig() {
        return this.kernelGatewayImageConfig;
    }

    public final JupyterLabAppImageConfig jupyterLabAppImageConfig() {
        return this.jupyterLabAppImageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appImageConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelGatewayImageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jupyterLabAppImageConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppImageConfigRequest)) {
            return false;
        }
        CreateAppImageConfigRequest other = (CreateAppImageConfigRequest)((Object)obj);
        return Objects.equals(this.appImageConfigName(), other.appImageConfigName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kernelGatewayImageConfig(), other.kernelGatewayImageConfig()) && Objects.equals(this.jupyterLabAppImageConfig(), other.jupyterLabAppImageConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAppImageConfigRequest").add("AppImageConfigName", (Object)this.appImageConfigName()).add("Tags", this.hasTags() ? this.tags() : null).add("KernelGatewayImageConfig", (Object)this.kernelGatewayImageConfig()).add("JupyterLabAppImageConfig", (Object)this.jupyterLabAppImageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppImageConfigName": {
                return Optional.ofNullable(clazz.cast(this.appImageConfigName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KernelGatewayImageConfig": {
                return Optional.ofNullable(clazz.cast(this.kernelGatewayImageConfig()));
            }
            case "JupyterLabAppImageConfig": {
                return Optional.ofNullable(clazz.cast(this.jupyterLabAppImageConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppImageConfigRequest, T> g) {
        return obj -> g.apply((CreateAppImageConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String appImageConfigName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private KernelGatewayImageConfig kernelGatewayImageConfig;
        private JupyterLabAppImageConfig jupyterLabAppImageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppImageConfigRequest model) {
            super(model);
            this.appImageConfigName(model.appImageConfigName);
            this.tags(model.tags);
            this.kernelGatewayImageConfig(model.kernelGatewayImageConfig);
            this.jupyterLabAppImageConfig(model.jupyterLabAppImageConfig);
        }

        public final String getAppImageConfigName() {
            return this.appImageConfigName;
        }

        public final void setAppImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
        }

        @Override
        public final Builder appImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final KernelGatewayImageConfig.Builder getKernelGatewayImageConfig() {
            return this.kernelGatewayImageConfig != null ? this.kernelGatewayImageConfig.toBuilder() : null;
        }

        public final void setKernelGatewayImageConfig(KernelGatewayImageConfig.BuilderImpl kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig != null ? kernelGatewayImageConfig.build() : null;
        }

        @Override
        public final Builder kernelGatewayImageConfig(KernelGatewayImageConfig kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig;
            return this;
        }

        public final JupyterLabAppImageConfig.Builder getJupyterLabAppImageConfig() {
            return this.jupyterLabAppImageConfig != null ? this.jupyterLabAppImageConfig.toBuilder() : null;
        }

        public final void setJupyterLabAppImageConfig(JupyterLabAppImageConfig.BuilderImpl jupyterLabAppImageConfig) {
            this.jupyterLabAppImageConfig = jupyterLabAppImageConfig != null ? jupyterLabAppImageConfig.build() : null;
        }

        @Override
        public final Builder jupyterLabAppImageConfig(JupyterLabAppImageConfig jupyterLabAppImageConfig) {
            this.jupyterLabAppImageConfig = jupyterLabAppImageConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppImageConfigRequest build() {
            return new CreateAppImageConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppImageConfigRequest> {
        public Builder appImageConfigName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kernelGatewayImageConfig(KernelGatewayImageConfig var1);

        default public Builder kernelGatewayImageConfig(Consumer<KernelGatewayImageConfig.Builder> kernelGatewayImageConfig) {
            return this.kernelGatewayImageConfig((KernelGatewayImageConfig)((KernelGatewayImageConfig.Builder)KernelGatewayImageConfig.builder().applyMutation(kernelGatewayImageConfig)).build());
        }

        public Builder jupyterLabAppImageConfig(JupyterLabAppImageConfig var1);

        default public Builder jupyterLabAppImageConfig(Consumer<JupyterLabAppImageConfig.Builder> jupyterLabAppImageConfig) {
            return this.jupyterLabAppImageConfig((JupyterLabAppImageConfig)((JupyterLabAppImageConfig.Builder)JupyterLabAppImageConfig.builder().applyMutation(jupyterLabAppImageConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

