/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType;
import software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftDatasetDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftDatasetDefinition> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(RedshiftDatasetDefinition.getter(RedshiftDatasetDefinition::clusterId)).setter(RedshiftDatasetDefinition.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(RedshiftDatasetDefinition.getter(RedshiftDatasetDefinition::database)).setter(RedshiftDatasetDefinition.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(RedshiftDatasetDefinition.getter(RedshiftDatasetDefinition::dbUser)).setter(RedshiftDatasetDefinition.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(RedshiftDatasetDefinition.getter(RedshiftDatasetDefinition::queryString)).setter(RedshiftDatasetDefinition.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<String> CLUSTER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterRoleArn").getter(RedshiftDatasetDefinition.getter(RedshiftDatasetDefinition::clusterRoleArn)).setter(RedshiftDatasetDefinition.setter(Builder::clusterRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterRoleArn").build()}).build();
    private static final SdkField<String> OUTPUT_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3Uri").getter(RedshiftDatasetDefinition.getter(RedshiftDatasetDefinition::outputS3Uri)).setter(RedshiftDatasetDefinition.setter(Builder::outputS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Uri").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(RedshiftDatasetDefinition.getter(RedshiftDatasetDefinition::kmsKeyId)).setter(RedshiftDatasetDefinition.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(RedshiftDatasetDefinition.getter(RedshiftDatasetDefinition::outputFormatAsString)).setter(RedshiftDatasetDefinition.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final SdkField<String> OUTPUT_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputCompression").getter(RedshiftDatasetDefinition.getter(RedshiftDatasetDefinition::outputCompressionAsString)).setter(RedshiftDatasetDefinition.setter(Builder::outputCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputCompression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, DATABASE_FIELD, DB_USER_FIELD, QUERY_STRING_FIELD, CLUSTER_ROLE_ARN_FIELD, OUTPUT_S3_URI_FIELD, KMS_KEY_ID_FIELD, OUTPUT_FORMAT_FIELD, OUTPUT_COMPRESSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterId;
    private final String database;
    private final String dbUser;
    private final String queryString;
    private final String clusterRoleArn;
    private final String outputS3Uri;
    private final String kmsKeyId;
    private final String outputFormat;
    private final String outputCompression;

    private RedshiftDatasetDefinition(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.queryString = builder.queryString;
        this.clusterRoleArn = builder.clusterRoleArn;
        this.outputS3Uri = builder.outputS3Uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.outputFormat = builder.outputFormat;
        this.outputCompression = builder.outputCompression;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String database() {
        return this.database;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final String clusterRoleArn() {
        return this.clusterRoleArn;
    }

    public final String outputS3Uri() {
        return this.outputS3Uri;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final RedshiftResultFormat outputFormat() {
        return RedshiftResultFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final RedshiftResultCompressionType outputCompression() {
        return RedshiftResultCompressionType.fromValue(this.outputCompression);
    }

    public final String outputCompressionAsString() {
        return this.outputCompression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputCompressionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDatasetDefinition)) {
            return false;
        }
        RedshiftDatasetDefinition other = (RedshiftDatasetDefinition)obj;
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.clusterRoleArn(), other.clusterRoleArn()) && Objects.equals(this.outputS3Uri(), other.outputS3Uri()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.outputCompressionAsString(), other.outputCompressionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftDatasetDefinition").add("ClusterId", (Object)this.clusterId()).add("Database", (Object)this.database()).add("DbUser", (Object)this.dbUser()).add("QueryString", (Object)this.queryString()).add("ClusterRoleArn", (Object)this.clusterRoleArn()).add("OutputS3Uri", (Object)this.outputS3Uri()).add("KmsKeyId", (Object)this.kmsKeyId()).add("OutputFormat", (Object)this.outputFormatAsString()).add("OutputCompression", (Object)this.outputCompressionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "ClusterRoleArn": {
                return Optional.ofNullable(clazz.cast(this.clusterRoleArn()));
            }
            case "OutputS3Uri": {
                return Optional.ofNullable(clazz.cast(this.outputS3Uri()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "OutputCompression": {
                return Optional.ofNullable(clazz.cast(this.outputCompressionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDatasetDefinition, T> g) {
        return obj -> g.apply((RedshiftDatasetDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private String database;
        private String dbUser;
        private String queryString;
        private String clusterRoleArn;
        private String outputS3Uri;
        private String kmsKeyId;
        private String outputFormat;
        private String outputCompression;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDatasetDefinition model) {
            this.clusterId(model.clusterId);
            this.database(model.database);
            this.dbUser(model.dbUser);
            this.queryString(model.queryString);
            this.clusterRoleArn(model.clusterRoleArn);
            this.outputS3Uri(model.outputS3Uri);
            this.kmsKeyId(model.kmsKeyId);
            this.outputFormat(model.outputFormat);
            this.outputCompression(model.outputCompression);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getClusterRoleArn() {
            return this.clusterRoleArn;
        }

        public final void setClusterRoleArn(String clusterRoleArn) {
            this.clusterRoleArn = clusterRoleArn;
        }

        @Override
        public final Builder clusterRoleArn(String clusterRoleArn) {
            this.clusterRoleArn = clusterRoleArn;
            return this;
        }

        public final String getOutputS3Uri() {
            return this.outputS3Uri;
        }

        public final void setOutputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
        }

        @Override
        public final Builder outputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(RedshiftResultFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final String getOutputCompression() {
            return this.outputCompression;
        }

        public final void setOutputCompression(String outputCompression) {
            this.outputCompression = outputCompression;
        }

        @Override
        public final Builder outputCompression(String outputCompression) {
            this.outputCompression = outputCompression;
            return this;
        }

        @Override
        public final Builder outputCompression(RedshiftResultCompressionType outputCompression) {
            this.outputCompression(outputCompression == null ? null : outputCompression.toString());
            return this;
        }

        public RedshiftDatasetDefinition build() {
            return new RedshiftDatasetDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftDatasetDefinition> {
        public Builder clusterId(String var1);

        public Builder database(String var1);

        public Builder dbUser(String var1);

        public Builder queryString(String var1);

        public Builder clusterRoleArn(String var1);

        public Builder outputS3Uri(String var1);

        public Builder kmsKeyId(String var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(RedshiftResultFormat var1);

        public Builder outputCompression(String var1);

        public Builder outputCompression(RedshiftResultCompressionType var1);
    }
}

