/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RoutingStrategy {
    LEAST_OUTSTANDING_REQUESTS("LEAST_OUTSTANDING_REQUESTS"),
    RANDOM("RANDOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RoutingStrategy> VALUE_MAP;
    private final String value;

    private RoutingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RoutingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RoutingStrategy> knownValues() {
        EnumSet<RoutingStrategy> knownValues = EnumSet.allOf(RoutingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RoutingStrategy.class, RoutingStrategy::toString);
    }
}

