/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.SubscribedWorkteam;

public class ListSubscribedWorkteamsIterable
implements SdkIterable<ListSubscribedWorkteamsResponse> {
    private final SageMakerClient client;
    private final ListSubscribedWorkteamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscribedWorkteamsIterable(SageMakerClient client, ListSubscribedWorkteamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubscribedWorkteamsResponseFetcher();
    }

    public Iterator<ListSubscribedWorkteamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SubscribedWorkteam> subscribedWorkteams() {
        Function<ListSubscribedWorkteamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscribedWorkteams() != null) {
                return response.subscribedWorkteams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubscribedWorkteamsResponseFetcher
    implements SyncPageFetcher<ListSubscribedWorkteamsResponse> {
        private ListSubscribedWorkteamsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscribedWorkteamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubscribedWorkteamsResponse nextPage(ListSubscribedWorkteamsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscribedWorkteamsIterable.this.client.listSubscribedWorkteams(ListSubscribedWorkteamsIterable.this.firstRequest);
            }
            return ListSubscribedWorkteamsIterable.this.client.listSubscribedWorkteams((ListSubscribedWorkteamsRequest)((Object)ListSubscribedWorkteamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

