/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MetricsSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelQuality
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelQuality> {
    private static final SdkField<MetricsSource> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Statistics").getter(ModelQuality.getter(ModelQuality::statistics)).setter(ModelQuality.setter(Builder::statistics)).constructor(MetricsSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()}).build();
    private static final SdkField<MetricsSource> CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Constraints").getter(ModelQuality.getter(ModelQuality::constraints)).setter(ModelQuality.setter(Builder::constraints)).constructor(MetricsSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_FIELD, CONSTRAINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final MetricsSource statistics;
    private final MetricsSource constraints;

    private ModelQuality(BuilderImpl builder) {
        this.statistics = builder.statistics;
        this.constraints = builder.constraints;
    }

    public final MetricsSource statistics() {
        return this.statistics;
    }

    public final MetricsSource constraints() {
        return this.constraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelQuality)) {
            return false;
        }
        ModelQuality other = (ModelQuality)obj;
        return Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.constraints(), other.constraints());
    }

    public final String toString() {
        return ToString.builder((String)"ModelQuality").add("Statistics", (Object)this.statistics()).add("Constraints", (Object)this.constraints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "Constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelQuality, T> g) {
        return obj -> g.apply((ModelQuality)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MetricsSource statistics;
        private MetricsSource constraints;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelQuality model) {
            this.statistics(model.statistics);
            this.constraints(model.constraints);
        }

        public final MetricsSource.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(MetricsSource.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(MetricsSource statistics) {
            this.statistics = statistics;
            return this;
        }

        public final MetricsSource.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        public final void setConstraints(MetricsSource.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(MetricsSource constraints) {
            this.constraints = constraints;
            return this;
        }

        public ModelQuality build() {
            return new ModelQuality(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelQuality> {
        public Builder statistics(MetricsSource var1);

        default public Builder statistics(Consumer<MetricsSource.Builder> statistics) {
            return this.statistics((MetricsSource)((MetricsSource.Builder)MetricsSource.builder().applyMutation(statistics)).build());
        }

        public Builder constraints(MetricsSource var1);

        default public Builder constraints(Consumer<MetricsSource.Builder> constraints) {
            return this.constraints((MetricsSource)((MetricsSource.Builder)MetricsSource.builder().applyMutation(constraints)).build());
        }
    }
}

