/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.EFSFileSystemConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomFileSystemConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomFileSystemConfig> {
    private static final SdkField<EFSFileSystemConfig> EFS_FILE_SYSTEM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EFSFileSystemConfig").getter(CustomFileSystemConfig.getter(CustomFileSystemConfig::efsFileSystemConfig)).setter(CustomFileSystemConfig.setter(Builder::efsFileSystemConfig)).constructor(EFSFileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EFSFileSystemConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFS_FILE_SYSTEM_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final EFSFileSystemConfig efsFileSystemConfig;
    private final Type type;

    private CustomFileSystemConfig(BuilderImpl builder) {
        this.efsFileSystemConfig = builder.efsFileSystemConfig;
        this.type = builder.type;
    }

    public final EFSFileSystemConfig efsFileSystemConfig() {
        return this.efsFileSystemConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.efsFileSystemConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFileSystemConfig)) {
            return false;
        }
        CustomFileSystemConfig other = (CustomFileSystemConfig)obj;
        return Objects.equals(this.efsFileSystemConfig(), other.efsFileSystemConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CustomFileSystemConfig").add("EFSFileSystemConfig", (Object)this.efsFileSystemConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EFSFileSystemConfig": {
                return Optional.ofNullable(clazz.cast(this.efsFileSystemConfig()));
            }
        }
        return Optional.empty();
    }

    public static CustomFileSystemConfig fromEfsFileSystemConfig(EFSFileSystemConfig efsFileSystemConfig) {
        return (CustomFileSystemConfig)CustomFileSystemConfig.builder().efsFileSystemConfig(efsFileSystemConfig).build();
    }

    public static CustomFileSystemConfig fromEfsFileSystemConfig(Consumer<EFSFileSystemConfig.Builder> efsFileSystemConfig) {
        EFSFileSystemConfig.Builder builder = EFSFileSystemConfig.builder();
        efsFileSystemConfig.accept(builder);
        return CustomFileSystemConfig.fromEfsFileSystemConfig((EFSFileSystemConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomFileSystemConfig, T> g) {
        return obj -> g.apply((CustomFileSystemConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EFS_FILE_SYSTEM_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EFSFileSystemConfig efsFileSystemConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFileSystemConfig model) {
            this.efsFileSystemConfig(model.efsFileSystemConfig);
        }

        public final EFSFileSystemConfig.Builder getEfsFileSystemConfig() {
            return this.efsFileSystemConfig != null ? this.efsFileSystemConfig.toBuilder() : null;
        }

        public final void setEfsFileSystemConfig(EFSFileSystemConfig.BuilderImpl efsFileSystemConfig) {
            EFSFileSystemConfig oldValue = this.efsFileSystemConfig;
            this.efsFileSystemConfig = efsFileSystemConfig != null ? efsFileSystemConfig.build() : null;
            this.handleUnionValueChange(Type.EFS_FILE_SYSTEM_CONFIG, oldValue, this.efsFileSystemConfig);
        }

        @Override
        public final Builder efsFileSystemConfig(EFSFileSystemConfig efsFileSystemConfig) {
            EFSFileSystemConfig oldValue = this.efsFileSystemConfig;
            this.efsFileSystemConfig = efsFileSystemConfig;
            this.handleUnionValueChange(Type.EFS_FILE_SYSTEM_CONFIG, oldValue, this.efsFileSystemConfig);
            return this;
        }

        public CustomFileSystemConfig build() {
            return new CustomFileSystemConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomFileSystemConfig> {
        public Builder efsFileSystemConfig(EFSFileSystemConfig var1);

        default public Builder efsFileSystemConfig(Consumer<EFSFileSystemConfig.Builder> efsFileSystemConfig) {
            return this.efsFileSystemConfig((EFSFileSystemConfig)((EFSFileSystemConfig.Builder)EFSFileSystemConfig.builder().applyMutation(efsFileSystemConfig)).build());
        }
    }
}

