/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InferenceComponentStatus {
    IN_SERVICE("InService"),
    CREATING("Creating"),
    UPDATING("Updating"),
    FAILED("Failed"),
    DELETING("Deleting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InferenceComponentStatus> VALUE_MAP;
    private final String value;

    private InferenceComponentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InferenceComponentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InferenceComponentStatus> knownValues() {
        EnumSet<InferenceComponentStatus> knownValues = EnumSet.allOf(InferenceComponentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InferenceComponentStatus.class, InferenceComponentStatus::toString);
    }
}

