/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.OutputCompressionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputDataConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(OutputDataConfig.getter(OutputDataConfig::kmsKeyId)).setter(OutputDataConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(OutputDataConfig.getter(OutputDataConfig::s3OutputPath)).setter(OutputDataConfig.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionType").getter(OutputDataConfig.getter(OutputDataConfig::compressionTypeAsString)).setter(OutputDataConfig.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, S3_OUTPUT_PATH_FIELD, COMPRESSION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String s3OutputPath;
    private final String compressionType;

    private OutputDataConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.s3OutputPath = builder.s3OutputPath;
        this.compressionType = builder.compressionType;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String s3OutputPath() {
        return this.s3OutputPath;
    }

    public final OutputCompressionType compressionType() {
        return OutputCompressionType.fromValue(this.compressionType);
    }

    public final String compressionTypeAsString() {
        return this.compressionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDataConfig)) {
            return false;
        }
        OutputDataConfig other = (OutputDataConfig)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OutputDataConfig").add("KmsKeyId", (Object)this.kmsKeyId()).add("S3OutputPath", (Object)this.s3OutputPath()).add("CompressionType", (Object)this.compressionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputDataConfig, T> g) {
        return obj -> g.apply((OutputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String s3OutputPath;
        private String compressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDataConfig model) {
            this.kmsKeyId(model.kmsKeyId);
            this.s3OutputPath(model.s3OutputPath);
            this.compressionType(model.compressionType);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(OutputCompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public OutputDataConfig build() {
            return new OutputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputDataConfig> {
        public Builder kmsKeyId(String var1);

        public Builder s3OutputPath(String var1);

        public Builder compressionType(String var1);

        public Builder compressionType(OutputCompressionType var1);
    }
}

