/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SpaceSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSpaceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateSpaceRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(UpdateSpaceRequest.getter(UpdateSpaceRequest::domainId)).setter(UpdateSpaceRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceName").getter(UpdateSpaceRequest.getter(UpdateSpaceRequest::spaceName)).setter(UpdateSpaceRequest.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()}).build();
    private static final SdkField<SpaceSettings> SPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceSettings").getter(UpdateSpaceRequest.getter(UpdateSpaceRequest::spaceSettings)).setter(UpdateSpaceRequest.setter(Builder::spaceSettings)).constructor(SpaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, SPACE_NAME_FIELD, SPACE_SETTINGS_FIELD));
    private final String domainId;
    private final String spaceName;
    private final SpaceSettings spaceSettings;

    private UpdateSpaceRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.spaceName = builder.spaceName;
        this.spaceSettings = builder.spaceSettings;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final SpaceSettings spaceSettings() {
        return this.spaceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSpaceRequest)) {
            return false;
        }
        UpdateSpaceRequest other = (UpdateSpaceRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.spaceSettings(), other.spaceSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSpaceRequest").add("DomainId", (Object)this.domainId()).add("SpaceName", (Object)this.spaceName()).add("SpaceSettings", (Object)this.spaceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "SpaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "SpaceSettings": {
                return Optional.ofNullable(clazz.cast(this.spaceSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSpaceRequest, T> g) {
        return obj -> g.apply((UpdateSpaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private String spaceName;
        private SpaceSettings spaceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSpaceRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.spaceName(model.spaceName);
            this.spaceSettings(model.spaceSettings);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final SpaceSettings.Builder getSpaceSettings() {
            return this.spaceSettings != null ? this.spaceSettings.toBuilder() : null;
        }

        public final void setSpaceSettings(SpaceSettings.BuilderImpl spaceSettings) {
            this.spaceSettings = spaceSettings != null ? spaceSettings.build() : null;
        }

        @Override
        public final Builder spaceSettings(SpaceSettings spaceSettings) {
            this.spaceSettings = spaceSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSpaceRequest build() {
            return new UpdateSpaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSpaceRequest> {
        public Builder domainId(String var1);

        public Builder spaceName(String var1);

        public Builder spaceSettings(SpaceSettings var1);

        default public Builder spaceSettings(Consumer<SpaceSettings.Builder> spaceSettings) {
            return this.spaceSettings((SpaceSettings)((SpaceSettings.Builder)SpaceSettings.builder().applyMutation(spaceSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

