/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceDeploymentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceDeploymentSummary> {
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeDeploymentPlanArn").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::edgeDeploymentPlanArn)).setter(DeviceDeploymentSummary.setter(Builder::edgeDeploymentPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanArn").build()}).build();
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeDeploymentPlanName").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::edgeDeploymentPlanName)).setter(DeviceDeploymentSummary.setter(Builder::edgeDeploymentPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanName").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::stageName)).setter(DeviceDeploymentSummary.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()}).build();
    private static final SdkField<String> DEPLOYED_STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeployedStageName").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::deployedStageName)).setter(DeviceDeploymentSummary.setter(Builder::deployedStageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeployedStageName").build()}).build();
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::deviceFleetName)).setter(DeviceDeploymentSummary.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::deviceName)).setter(DeviceDeploymentSummary.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceArn").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::deviceArn)).setter(DeviceDeploymentSummary.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()}).build();
    private static final SdkField<String> DEVICE_DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceDeploymentStatus").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::deviceDeploymentStatusAsString)).setter(DeviceDeploymentSummary.setter(Builder::deviceDeploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceDeploymentStatus").build()}).build();
    private static final SdkField<String> DEVICE_DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceDeploymentStatusMessage").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::deviceDeploymentStatusMessage)).setter(DeviceDeploymentSummary.setter(Builder::deviceDeploymentStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceDeploymentStatusMessage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::description)).setter(DeviceDeploymentSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> DEPLOYMENT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeploymentStartTime").getter(DeviceDeploymentSummary.getter(DeviceDeploymentSummary::deploymentStartTime)).setter(DeviceDeploymentSummary.setter(Builder::deploymentStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_DEPLOYMENT_PLAN_ARN_FIELD, EDGE_DEPLOYMENT_PLAN_NAME_FIELD, STAGE_NAME_FIELD, DEPLOYED_STAGE_NAME_FIELD, DEVICE_FLEET_NAME_FIELD, DEVICE_NAME_FIELD, DEVICE_ARN_FIELD, DEVICE_DEPLOYMENT_STATUS_FIELD, DEVICE_DEPLOYMENT_STATUS_MESSAGE_FIELD, DESCRIPTION_FIELD, DEPLOYMENT_START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String edgeDeploymentPlanArn;
    private final String edgeDeploymentPlanName;
    private final String stageName;
    private final String deployedStageName;
    private final String deviceFleetName;
    private final String deviceName;
    private final String deviceArn;
    private final String deviceDeploymentStatus;
    private final String deviceDeploymentStatusMessage;
    private final String description;
    private final Instant deploymentStartTime;

    private DeviceDeploymentSummary(BuilderImpl builder) {
        this.edgeDeploymentPlanArn = builder.edgeDeploymentPlanArn;
        this.edgeDeploymentPlanName = builder.edgeDeploymentPlanName;
        this.stageName = builder.stageName;
        this.deployedStageName = builder.deployedStageName;
        this.deviceFleetName = builder.deviceFleetName;
        this.deviceName = builder.deviceName;
        this.deviceArn = builder.deviceArn;
        this.deviceDeploymentStatus = builder.deviceDeploymentStatus;
        this.deviceDeploymentStatusMessage = builder.deviceDeploymentStatusMessage;
        this.description = builder.description;
        this.deploymentStartTime = builder.deploymentStartTime;
    }

    public final String edgeDeploymentPlanArn() {
        return this.edgeDeploymentPlanArn;
    }

    public final String edgeDeploymentPlanName() {
        return this.edgeDeploymentPlanName;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final String deployedStageName() {
        return this.deployedStageName;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final DeviceDeploymentStatus deviceDeploymentStatus() {
        return DeviceDeploymentStatus.fromValue(this.deviceDeploymentStatus);
    }

    public final String deviceDeploymentStatusAsString() {
        return this.deviceDeploymentStatus;
    }

    public final String deviceDeploymentStatusMessage() {
        return this.deviceDeploymentStatusMessage;
    }

    public final String description() {
        return this.description;
    }

    public final Instant deploymentStartTime() {
        return this.deploymentStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployedStageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceDeploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDeploymentSummary)) {
            return false;
        }
        DeviceDeploymentSummary other = (DeviceDeploymentSummary)obj;
        return Objects.equals(this.edgeDeploymentPlanArn(), other.edgeDeploymentPlanArn()) && Objects.equals(this.edgeDeploymentPlanName(), other.edgeDeploymentPlanName()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.deployedStageName(), other.deployedStageName()) && Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceDeploymentStatusAsString(), other.deviceDeploymentStatusAsString()) && Objects.equals(this.deviceDeploymentStatusMessage(), other.deviceDeploymentStatusMessage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deploymentStartTime(), other.deploymentStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceDeploymentSummary").add("EdgeDeploymentPlanArn", (Object)this.edgeDeploymentPlanArn()).add("EdgeDeploymentPlanName", (Object)this.edgeDeploymentPlanName()).add("StageName", (Object)this.stageName()).add("DeployedStageName", (Object)this.deployedStageName()).add("DeviceFleetName", (Object)this.deviceFleetName()).add("DeviceName", (Object)this.deviceName()).add("DeviceArn", (Object)this.deviceArn()).add("DeviceDeploymentStatus", (Object)this.deviceDeploymentStatusAsString()).add("DeviceDeploymentStatusMessage", (Object)this.deviceDeploymentStatusMessage()).add("Description", (Object)this.description()).add("DeploymentStartTime", (Object)this.deploymentStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgeDeploymentPlanArn": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentPlanArn()));
            }
            case "EdgeDeploymentPlanName": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentPlanName()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "DeployedStageName": {
                return Optional.ofNullable(clazz.cast(this.deployedStageName()));
            }
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "DeviceDeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceDeploymentStatusAsString()));
            }
            case "DeviceDeploymentStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.deviceDeploymentStatusMessage()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeploymentStartTime": {
                return Optional.ofNullable(clazz.cast(this.deploymentStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceDeploymentSummary, T> g) {
        return obj -> g.apply((DeviceDeploymentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String edgeDeploymentPlanArn;
        private String edgeDeploymentPlanName;
        private String stageName;
        private String deployedStageName;
        private String deviceFleetName;
        private String deviceName;
        private String deviceArn;
        private String deviceDeploymentStatus;
        private String deviceDeploymentStatusMessage;
        private String description;
        private Instant deploymentStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceDeploymentSummary model) {
            this.edgeDeploymentPlanArn(model.edgeDeploymentPlanArn);
            this.edgeDeploymentPlanName(model.edgeDeploymentPlanName);
            this.stageName(model.stageName);
            this.deployedStageName(model.deployedStageName);
            this.deviceFleetName(model.deviceFleetName);
            this.deviceName(model.deviceName);
            this.deviceArn(model.deviceArn);
            this.deviceDeploymentStatus(model.deviceDeploymentStatus);
            this.deviceDeploymentStatusMessage(model.deviceDeploymentStatusMessage);
            this.description(model.description);
            this.deploymentStartTime(model.deploymentStartTime);
        }

        public final String getEdgeDeploymentPlanArn() {
            return this.edgeDeploymentPlanArn;
        }

        public final void setEdgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
        }

        @Override
        public final Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
            return this;
        }

        public final String getEdgeDeploymentPlanName() {
            return this.edgeDeploymentPlanName;
        }

        public final void setEdgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
        }

        @Override
        public final Builder edgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getDeployedStageName() {
            return this.deployedStageName;
        }

        public final void setDeployedStageName(String deployedStageName) {
            this.deployedStageName = deployedStageName;
        }

        @Override
        public final Builder deployedStageName(String deployedStageName) {
            this.deployedStageName = deployedStageName;
            return this;
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceDeploymentStatus() {
            return this.deviceDeploymentStatus;
        }

        public final void setDeviceDeploymentStatus(String deviceDeploymentStatus) {
            this.deviceDeploymentStatus = deviceDeploymentStatus;
        }

        @Override
        public final Builder deviceDeploymentStatus(String deviceDeploymentStatus) {
            this.deviceDeploymentStatus = deviceDeploymentStatus;
            return this;
        }

        @Override
        public final Builder deviceDeploymentStatus(DeviceDeploymentStatus deviceDeploymentStatus) {
            this.deviceDeploymentStatus(deviceDeploymentStatus == null ? null : deviceDeploymentStatus.toString());
            return this;
        }

        public final String getDeviceDeploymentStatusMessage() {
            return this.deviceDeploymentStatusMessage;
        }

        public final void setDeviceDeploymentStatusMessage(String deviceDeploymentStatusMessage) {
            this.deviceDeploymentStatusMessage = deviceDeploymentStatusMessage;
        }

        @Override
        public final Builder deviceDeploymentStatusMessage(String deviceDeploymentStatusMessage) {
            this.deviceDeploymentStatusMessage = deviceDeploymentStatusMessage;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getDeploymentStartTime() {
            return this.deploymentStartTime;
        }

        public final void setDeploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
        }

        @Override
        public final Builder deploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
            return this;
        }

        public DeviceDeploymentSummary build() {
            return new DeviceDeploymentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceDeploymentSummary> {
        public Builder edgeDeploymentPlanArn(String var1);

        public Builder edgeDeploymentPlanName(String var1);

        public Builder stageName(String var1);

        public Builder deployedStageName(String var1);

        public Builder deviceFleetName(String var1);

        public Builder deviceName(String var1);

        public Builder deviceArn(String var1);

        public Builder deviceDeploymentStatus(String var1);

        public Builder deviceDeploymentStatus(DeviceDeploymentStatus var1);

        public Builder deviceDeploymentStatusMessage(String var1);

        public Builder description(String var1);

        public Builder deploymentStartTime(Instant var1);
    }
}

