/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria;
import software.amazon.awssdk.services.sagemaker.model.TextGenerationHyperParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextGenerationJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextGenerationJobConfig> {
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompletionCriteria").getter(TextGenerationJobConfig.getter(TextGenerationJobConfig::completionCriteria)).setter(TextGenerationJobConfig.setter(Builder::completionCriteria)).constructor(AutoMLJobCompletionCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build()}).build();
    private static final SdkField<String> BASE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseModelName").getter(TextGenerationJobConfig.getter(TextGenerationJobConfig::baseModelName)).setter(TextGenerationJobConfig.setter(Builder::baseModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseModelName").build()}).build();
    private static final SdkField<Map<String, String>> TEXT_GENERATION_HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TextGenerationHyperParameters").getter(TextGenerationJobConfig.getter(TextGenerationJobConfig::textGenerationHyperParameters)).setter(TextGenerationJobConfig.setter(Builder::textGenerationHyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextGenerationHyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_CRITERIA_FIELD, BASE_MODEL_NAME_FIELD, TEXT_GENERATION_HYPER_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AutoMLJobCompletionCriteria completionCriteria;
    private final String baseModelName;
    private final Map<String, String> textGenerationHyperParameters;

    private TextGenerationJobConfig(BuilderImpl builder) {
        this.completionCriteria = builder.completionCriteria;
        this.baseModelName = builder.baseModelName;
        this.textGenerationHyperParameters = builder.textGenerationHyperParameters;
    }

    public final AutoMLJobCompletionCriteria completionCriteria() {
        return this.completionCriteria;
    }

    public final String baseModelName() {
        return this.baseModelName;
    }

    public final boolean hasTextGenerationHyperParameters() {
        return this.textGenerationHyperParameters != null && !(this.textGenerationHyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> textGenerationHyperParameters() {
        return this.textGenerationHyperParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextGenerationHyperParameters() ? this.textGenerationHyperParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextGenerationJobConfig)) {
            return false;
        }
        TextGenerationJobConfig other = (TextGenerationJobConfig)obj;
        return Objects.equals(this.completionCriteria(), other.completionCriteria()) && Objects.equals(this.baseModelName(), other.baseModelName()) && this.hasTextGenerationHyperParameters() == other.hasTextGenerationHyperParameters() && Objects.equals(this.textGenerationHyperParameters(), other.textGenerationHyperParameters());
    }

    public final String toString() {
        return ToString.builder((String)"TextGenerationJobConfig").add("CompletionCriteria", (Object)this.completionCriteria()).add("BaseModelName", (Object)this.baseModelName()).add("TextGenerationHyperParameters", this.hasTextGenerationHyperParameters() ? this.textGenerationHyperParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompletionCriteria": {
                return Optional.ofNullable(clazz.cast(this.completionCriteria()));
            }
            case "BaseModelName": {
                return Optional.ofNullable(clazz.cast(this.baseModelName()));
            }
            case "TextGenerationHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.textGenerationHyperParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextGenerationJobConfig, T> g) {
        return obj -> g.apply((TextGenerationJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoMLJobCompletionCriteria completionCriteria;
        private String baseModelName;
        private Map<String, String> textGenerationHyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TextGenerationJobConfig model) {
            this.completionCriteria(model.completionCriteria);
            this.baseModelName(model.baseModelName);
            this.textGenerationHyperParameters(model.textGenerationHyperParameters);
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return this.completionCriteria != null ? this.completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final String getBaseModelName() {
            return this.baseModelName;
        }

        public final void setBaseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
        }

        @Override
        public final Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        public final Map<String, String> getTextGenerationHyperParameters() {
            if (this.textGenerationHyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.textGenerationHyperParameters;
        }

        public final void setTextGenerationHyperParameters(Map<String, String> textGenerationHyperParameters) {
            this.textGenerationHyperParameters = TextGenerationHyperParametersCopier.copy(textGenerationHyperParameters);
        }

        @Override
        public final Builder textGenerationHyperParameters(Map<String, String> textGenerationHyperParameters) {
            this.textGenerationHyperParameters = TextGenerationHyperParametersCopier.copy(textGenerationHyperParameters);
            return this;
        }

        public TextGenerationJobConfig build() {
            return new TextGenerationJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextGenerationJobConfig> {
        public Builder completionCriteria(AutoMLJobCompletionCriteria var1);

        default public Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return this.completionCriteria((AutoMLJobCompletionCriteria)((AutoMLJobCompletionCriteria.Builder)AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria)).build());
        }

        public Builder baseModelName(String var1);

        public Builder textGenerationHyperParameters(Map<String, String> var1);
    }
}

