/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary;

public class ListModelCardVersionsPublisher
implements SdkPublisher<ListModelCardVersionsResponse> {
    private final SageMakerAsyncClient client;
    private final ListModelCardVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelCardVersionsPublisher(SageMakerAsyncClient client, ListModelCardVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelCardVersionsPublisher(SageMakerAsyncClient client, ListModelCardVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelCardVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelCardVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelCardVersionSummary> modelCardVersionSummaryList() {
        Function<ListModelCardVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelCardVersionSummaryList() != null) {
                return response.modelCardVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelCardVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelCardVersionsResponseFetcher
    implements AsyncPageFetcher<ListModelCardVersionsResponse> {
        private ListModelCardVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCardVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelCardVersionsResponse> nextPage(ListModelCardVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCardVersionsPublisher.this.client.listModelCardVersions(ListModelCardVersionsPublisher.this.firstRequest);
            }
            return ListModelCardVersionsPublisher.this.client.listModelCardVersions((ListModelCardVersionsRequest)((Object)ListModelCardVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

