/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextGenerationJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextGenerationJobConfig> {
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompletionCriteria").getter(TextGenerationJobConfig.getter(TextGenerationJobConfig::completionCriteria)).setter(TextGenerationJobConfig.setter(Builder::completionCriteria)).constructor(AutoMLJobCompletionCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build()}).build();
    private static final SdkField<String> BASE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseModelName").getter(TextGenerationJobConfig.getter(TextGenerationJobConfig::baseModelName)).setter(TextGenerationJobConfig.setter(Builder::baseModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseModelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_CRITERIA_FIELD, BASE_MODEL_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final AutoMLJobCompletionCriteria completionCriteria;
    private final String baseModelName;

    private TextGenerationJobConfig(BuilderImpl builder) {
        this.completionCriteria = builder.completionCriteria;
        this.baseModelName = builder.baseModelName;
    }

    public final AutoMLJobCompletionCriteria completionCriteria() {
        return this.completionCriteria;
    }

    public final String baseModelName() {
        return this.baseModelName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextGenerationJobConfig)) {
            return false;
        }
        TextGenerationJobConfig other = (TextGenerationJobConfig)obj;
        return Objects.equals(this.completionCriteria(), other.completionCriteria()) && Objects.equals(this.baseModelName(), other.baseModelName());
    }

    public final String toString() {
        return ToString.builder((String)"TextGenerationJobConfig").add("CompletionCriteria", (Object)this.completionCriteria()).add("BaseModelName", (Object)this.baseModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompletionCriteria": {
                return Optional.ofNullable(clazz.cast(this.completionCriteria()));
            }
            case "BaseModelName": {
                return Optional.ofNullable(clazz.cast(this.baseModelName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextGenerationJobConfig, T> g) {
        return obj -> g.apply((TextGenerationJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoMLJobCompletionCriteria completionCriteria;
        private String baseModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(TextGenerationJobConfig model) {
            this.completionCriteria(model.completionCriteria);
            this.baseModelName(model.baseModelName);
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return this.completionCriteria != null ? this.completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final String getBaseModelName() {
            return this.baseModelName;
        }

        public final void setBaseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
        }

        @Override
        public final Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        public TextGenerationJobConfig build() {
            return new TextGenerationJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextGenerationJobConfig> {
        public Builder completionCriteria(AutoMLJobCompletionCriteria var1);

        default public Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return this.completionCriteria((AutoMLJobCompletionCriteria)((AutoMLJobCompletionCriteria.Builder)AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria)).build());
        }

        public Builder baseModelName(String var1);
    }
}

