/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDataCaptureConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDataCaptureConfig> {
    private static final SdkField<String> DESTINATION_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationS3Uri").getter(BatchDataCaptureConfig.getter(BatchDataCaptureConfig::destinationS3Uri)).setter(BatchDataCaptureConfig.setter(Builder::destinationS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationS3Uri").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(BatchDataCaptureConfig.getter(BatchDataCaptureConfig::kmsKeyId)).setter(BatchDataCaptureConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> GENERATE_INFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GenerateInferenceId").getter(BatchDataCaptureConfig.getter(BatchDataCaptureConfig::generateInferenceId)).setter(BatchDataCaptureConfig.setter(Builder::generateInferenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerateInferenceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_S3_URI_FIELD, KMS_KEY_ID_FIELD, GENERATE_INFERENCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationS3Uri;
    private final String kmsKeyId;
    private final Boolean generateInferenceId;

    private BatchDataCaptureConfig(BuilderImpl builder) {
        this.destinationS3Uri = builder.destinationS3Uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.generateInferenceId = builder.generateInferenceId;
    }

    public final String destinationS3Uri() {
        return this.destinationS3Uri;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Boolean generateInferenceId() {
        return this.generateInferenceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generateInferenceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDataCaptureConfig)) {
            return false;
        }
        BatchDataCaptureConfig other = (BatchDataCaptureConfig)obj;
        return Objects.equals(this.destinationS3Uri(), other.destinationS3Uri()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.generateInferenceId(), other.generateInferenceId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDataCaptureConfig").add("DestinationS3Uri", (Object)this.destinationS3Uri()).add("KmsKeyId", (Object)this.kmsKeyId()).add("GenerateInferenceId", (Object)this.generateInferenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationS3Uri": {
                return Optional.ofNullable(clazz.cast(this.destinationS3Uri()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "GenerateInferenceId": {
                return Optional.ofNullable(clazz.cast(this.generateInferenceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDataCaptureConfig, T> g) {
        return obj -> g.apply((BatchDataCaptureConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationS3Uri;
        private String kmsKeyId;
        private Boolean generateInferenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDataCaptureConfig model) {
            this.destinationS3Uri(model.destinationS3Uri);
            this.kmsKeyId(model.kmsKeyId);
            this.generateInferenceId(model.generateInferenceId);
        }

        public final String getDestinationS3Uri() {
            return this.destinationS3Uri;
        }

        public final void setDestinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
        }

        @Override
        public final Builder destinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getGenerateInferenceId() {
            return this.generateInferenceId;
        }

        public final void setGenerateInferenceId(Boolean generateInferenceId) {
            this.generateInferenceId = generateInferenceId;
        }

        @Override
        public final Builder generateInferenceId(Boolean generateInferenceId) {
            this.generateInferenceId = generateInferenceId;
            return this;
        }

        public BatchDataCaptureConfig build() {
            return new BatchDataCaptureConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDataCaptureConfig> {
        public Builder destinationS3Uri(String var1);

        public Builder kmsKeyId(String var1);

        public Builder generateInferenceId(Boolean var1);
    }
}

