/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PipelineExecutionStatus {
    EXECUTING("Executing"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    FAILED("Failed"),
    SUCCEEDED("Succeeded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PipelineExecutionStatus> VALUE_MAP;
    private final String value;

    private PipelineExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PipelineExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PipelineExecutionStatus> knownValues() {
        EnumSet<PipelineExecutionStatus> knownValues = EnumSet.allOf(PipelineExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PipelineExecutionStatus.class, PipelineExecutionStatus::toString);
    }
}

