/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the number of training jobs that this hyperparameter tuning job launched, categorized by the status of
 * their objective metric. The objective metric status shows whether the final objective metric for the training job has
 * been evaluated by the tuning job and used in the hyperparameter tuning process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectiveStatusCounters implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectiveStatusCounters.Builder, ObjectiveStatusCounters> {
    private static final SdkField<Integer> SUCCEEDED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Succeeded").getter(getter(ObjectiveStatusCounters::succeeded)).setter(setter(Builder::succeeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Succeeded").build()).build();

    private static final SdkField<Integer> PENDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Pending").getter(getter(ObjectiveStatusCounters::pending)).setter(setter(Builder::pending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pending").build()).build();

    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Failed").getter(getter(ObjectiveStatusCounters::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCEEDED_FIELD,
            PENDING_FIELD, FAILED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer succeeded;

    private final Integer pending;

    private final Integer failed;

    private ObjectiveStatusCounters(BuilderImpl builder) {
        this.succeeded = builder.succeeded;
        this.pending = builder.pending;
        this.failed = builder.failed;
    }

    /**
     * <p>
     * The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning job and used
     * in the hyperparameter tuning process.
     * </p>
     * 
     * @return The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning job
     *         and used in the hyperparameter tuning process.
     */
    public final Integer succeeded() {
        return succeeded;
    }

    /**
     * <p>
     * The number of training jobs that are in progress and pending evaluation of their final objective metric.
     * </p>
     * 
     * @return The number of training jobs that are in progress and pending evaluation of their final objective metric.
     */
    public final Integer pending() {
        return pending;
    }

    /**
     * <p>
     * The number of training jobs whose final objective metric was not evaluated and used in the hyperparameter tuning
     * process. This typically occurs when the training job failed or did not emit an objective metric.
     * </p>
     * 
     * @return The number of training jobs whose final objective metric was not evaluated and used in the hyperparameter
     *         tuning process. This typically occurs when the training job failed or did not emit an objective metric.
     */
    public final Integer failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(succeeded());
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectiveStatusCounters)) {
            return false;
        }
        ObjectiveStatusCounters other = (ObjectiveStatusCounters) obj;
        return Objects.equals(succeeded(), other.succeeded()) && Objects.equals(pending(), other.pending())
                && Objects.equals(failed(), other.failed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectiveStatusCounters").add("Succeeded", succeeded()).add("Pending", pending())
                .add("Failed", failed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Succeeded":
            return Optional.ofNullable(clazz.cast(succeeded()));
        case "Pending":
            return Optional.ofNullable(clazz.cast(pending()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectiveStatusCounters, T> g) {
        return obj -> g.apply((ObjectiveStatusCounters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectiveStatusCounters> {
        /**
         * <p>
         * The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning job and
         * used in the hyperparameter tuning process.
         * </p>
         * 
         * @param succeeded
         *        The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning
         *        job and used in the hyperparameter tuning process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeeded(Integer succeeded);

        /**
         * <p>
         * The number of training jobs that are in progress and pending evaluation of their final objective metric.
         * </p>
         * 
         * @param pending
         *        The number of training jobs that are in progress and pending evaluation of their final objective
         *        metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Integer pending);

        /**
         * <p>
         * The number of training jobs whose final objective metric was not evaluated and used in the hyperparameter
         * tuning process. This typically occurs when the training job failed or did not emit an objective metric.
         * </p>
         * 
         * @param failed
         *        The number of training jobs whose final objective metric was not evaluated and used in the
         *        hyperparameter tuning process. This typically occurs when the training job failed or did not emit an
         *        objective metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);
    }

    static final class BuilderImpl implements Builder {
        private Integer succeeded;

        private Integer pending;

        private Integer failed;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectiveStatusCounters model) {
            succeeded(model.succeeded);
            pending(model.pending);
            failed(model.failed);
        }

        public final Integer getSucceeded() {
            return succeeded;
        }

        public final void setSucceeded(Integer succeeded) {
            this.succeeded = succeeded;
        }

        @Override
        public final Builder succeeded(Integer succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public final Integer getPending() {
            return pending;
        }

        public final void setPending(Integer pending) {
            this.pending = pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        @Override
        public ObjectiveStatusCounters build() {
            return new ObjectiveStatusCounters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
